/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.MappingException;
import java.lang.reflect.Method;
import org.bson.codecs.pojo.PropertyAccessor;

@MorphiaInternal
public class MethodAccessor
implements PropertyAccessor<Object> {
    private final Method getter;
    private final Method setter;

    @MorphiaInternal
    public MethodAccessor(Method getter, Method setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public <S> Object get(S instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    public <S> void set(S instance, Object value) {
        try {
            this.setter.invoke(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }
}

