/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.MorphiaCollectionPropertyCodecProvider;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.MorphiaMapPropertyCodecProvider;
import dev.morphia.mapping.codec.MorphiaPropertyCodecProvider;
import dev.morphia.mapping.codec.pojo.EntityDecoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.LifecycleDecoder;
import dev.morphia.mapping.codec.pojo.LifecycleEncoder;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PropertyCodecProvider;

@MorphiaInternal
public class MorphiaCodecProvider
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Mapper mapper;
    private final List<PropertyCodecProvider> propertyCodecProviders = new ArrayList<PropertyCodecProvider>();
    private Datastore datastore;

    public MorphiaCodecProvider(Datastore datastore) {
        this.datastore = datastore;
        this.mapper = datastore.getMapper();
        this.propertyCodecProviders.addAll(List.of(new MorphiaMapPropertyCodecProvider(), new MorphiaCollectionPropertyCodecProvider()));
        ServiceLoader<MorphiaPropertyCodecProvider> providers = ServiceLoader.load(MorphiaPropertyCodecProvider.class);
        providers.forEach(provider -> this.propertyCodecProviders.add((PropertyCodecProvider)provider));
    }

    protected Map<Class<?>, Codec<?>> getCodecs() {
        return this.codecs;
    }

    protected List<PropertyCodecProvider> getPropertyCodecProviders() {
        return this.propertyCodecProviders;
    }

    @Nullable
    public <T> Codec<T> get(Class<T> type, CodecRegistry registry) {
        MorphiaCodec codec = (MorphiaCodec)this.codecs.get(type);
        if (codec == null && (this.mapper.isMapped(type) || this.mapper.isMappable(type))) {
            EntityModel model = this.mapper.getEntityModel(type);
            codec = new MorphiaCodec(this.datastore, model, this.propertyCodecProviders, this.mapper.getDiscriminatorLookup(), registry);
            if (model.hasLifecycle(PostPersist.class) || model.hasLifecycle(PrePersist.class) || this.mapper.hasInterceptors()) {
                codec.setEncoder(new LifecycleEncoder(codec));
            }
            if (model.hasLifecycle(PreLoad.class) || model.hasLifecycle(PostLoad.class) || this.mapper.hasInterceptors()) {
                codec.setDecoder(new LifecycleDecoder(codec));
            }
            this.codecs.put(type, (Codec<?>)codec);
        }
        return codec;
    }

    @Nullable
    public <T> Codec<T> getRefreshCodec(final T entity, CodecRegistry registry) {
        EntityModel model = this.mapper.getEntityModel(entity.getClass());
        return new MorphiaCodec<T>(this.datastore, model, this.propertyCodecProviders, this.mapper.getDiscriminatorLookup(), registry){

            @Override
            protected EntityDecoder<T> getDecoder() {
                return new EntityDecoder<T>(this){

                    @Override
                    protected MorphiaInstanceCreator getInstanceCreator() {
                        return new MorphiaInstanceCreator(){

                            public T getInstance() {
                                return entity;
                            }

                            @Override
                            public void set(@Nullable Object value, PropertyModel model) {
                                model.getAccessor().set(entity, value);
                            }
                        };
                    }
                };
            }
        };
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    public String toString() {
        return String.format("MorphiaCodecProvider{propertyCodecProviders=%s}", this.propertyCodecProviders);
    }
}

