/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.MorphiaCollectionCodec;
import dev.morphia.mapping.codec.MorphiaPropertyCodecProvider;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.util.Collection;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;

@MorphiaInternal
public class MorphiaCollectionPropertyCodecProvider
extends MorphiaPropertyCodecProvider {
    @Nullable
    public <T> Codec<T> get(TypeWithTypeParameters<T> type, PropertyCodecRegistry registry) {
        if (Collection.class.isAssignableFrom(type.getType())) {
            List typeParameters = type.getTypeParameters();
            TypeWithTypeParameters<?> valueType = this.getType(typeParameters, 0);
            try {
                return new MorphiaCollectionCodec(registry.get(valueType), type.getType());
            }
            catch (CodecConfigurationException e) {
                if (valueType.getType().equals(Object.class)) {
                    try {
                        return registry.get(TypeData.get(Collection.class));
                    }
                    catch (CodecConfigurationException codecConfigurationException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return null;
    }
}

