/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.Datastore;
import java.time.Instant;
import java.time.LocalDate;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class MorphiaDateCodec
implements Codec<LocalDate> {
    private Datastore datastore;

    MorphiaDateCodec(Datastore datastore) {
        this.datastore = datastore;
    }

    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(reader.readDateTime()).atZone(this.datastore.getMapper().getConfig().dateStorage().getZone()).toLocalDate();
    }

    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        writer.writeDateTime(value.atStartOfDay(this.datastore.getMapper().getConfig().dateStorage().getZone()).toInstant().toEpochMilli());
    }

    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }
}

