/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.Datastore;
import java.time.Instant;
import java.time.LocalDateTime;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class MorphiaLocalDateTimeCodec
implements Codec<LocalDateTime> {
    private Datastore datastore;

    MorphiaLocalDateTimeCodec(Datastore datastore) {
        this.datastore = datastore;
    }

    public LocalDateTime decode(BsonReader reader, DecoderContext decoderContext) {
        if (reader.getCurrentBsonType().equals((Object)BsonType.INT64)) {
            return Instant.ofEpochMilli(reader.readInt64()).atZone(this.datastore.getMapper().getConfig().dateStorage().getZone()).toLocalDateTime();
        }
        return Instant.ofEpochMilli(reader.readDateTime()).atZone(this.datastore.getMapper().getConfig().dateStorage().getZone()).toLocalDateTime();
    }

    public void encode(BsonWriter writer, LocalDateTime value, EncoderContext encoderContext) {
        writer.writeDateTime(value.atZone(this.datastore.getMapper().getConfig().dateStorage().getZone()).toInstant().toEpochMilli());
    }

    public Class<LocalDateTime> getEncoderClass() {
        return LocalDateTime.class;
    }
}

