/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.Conversions;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.MapCodec;

@MorphiaInternal
public class MorphiaMapCodec
extends MapCodec {
    private Datastore datastore;

    MorphiaMapCodec(Datastore datastore) {
        this.datastore = datastore;
    }

    public void encode(BsonWriter writer, Map map, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                writer.writeName(Conversions.convert(key, String.class));
                if (entry.getValue() == null) {
                    writer.writeNull();
                    continue;
                }
                Codec codec = this.datastore.getCodecRegistry().get(entry.getValue().getClass());
                codec.encode(writer, entry.getValue(), encoderContext);
            }
        });
    }
}

