/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.MorphiaPropertyCodecProvider;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;

@MorphiaInternal
class MorphiaMapPropertyCodecProvider
extends MorphiaPropertyCodecProvider {
    MorphiaMapPropertyCodecProvider() {
    }

    public <T> Codec<T> get(TypeWithTypeParameters<T> type, PropertyCodecRegistry registry) {
        if (Map.class.isAssignableFrom(type.getType())) {
            List typeParameters = type.getTypeParameters();
            TypeWithTypeParameters<?> keyType = this.getType(typeParameters, 0);
            TypeWithTypeParameters<?> valueType = this.getType(typeParameters, 1);
            try {
                return new MapCodec(type.getType(), keyType.getType(), registry.get(valueType));
            }
            catch (CodecConfigurationException e) {
                if (valueType.getType().equals(Object.class)) {
                    try {
                        return registry.get(TypeData.get(Map.class));
                    }
                    catch (CodecConfigurationException codecConfigurationException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return null;
    }

    private static class MapCodec<K, V>
    implements Codec<Map<K, V>> {
        private final Class<Map<K, V>> encoderClass;
        private final Class<K> keyType;
        private final Codec<V> codec;

        MapCodec(Class<Map<K, V>> encoderClass, Class<K> keyType, Codec<V> codec) {
            this.encoderClass = encoderClass;
            this.keyType = keyType;
            this.codec = codec;
        }

        public void encode(BsonWriter writer, Map<K, V> map, EncoderContext encoderContext) {
            ExpressionHelper.document(writer, () -> {
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    writer.writeName(Conversions.convert(key, String.class));
                    if (entry.getValue() == null) {
                        writer.writeNull();
                        continue;
                    }
                    this.codec.encode(writer, entry.getValue(), encoderContext);
                }
            });
        }

        public Map<K, V> decode(BsonReader reader, DecoderContext context) {
            reader.readStartDocument();
            Map<K, Object> map = this.getInstance();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                K key = Conversions.convert(reader.readName(), this.keyType);
                if (reader.getCurrentBsonType() == BsonType.NULL) {
                    map.put(key, null);
                    reader.readNull();
                    continue;
                }
                map.put(key, this.codec.decode(reader, context));
            }
            reader.readEndDocument();
            return map;
        }

        public Class<Map<K, V>> getEncoderClass() {
            return this.encoderClass;
        }

        private Map<K, V> getInstance() {
            if (this.encoderClass.isInterface()) {
                return new HashMap();
            }
            try {
                Constructor<Map<K, V>> constructor = this.encoderClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CodecConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

