/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.LoadOnly;
import dev.morphia.annotations.NotSaved;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.codecs.pojo.PropertySerialization;

public class MorphiaPropertySerialization
implements PropertySerialization {
    private final List<Annotation> annotations;
    private final MorphiaConfig config;
    private final int modifiers;

    public MorphiaPropertySerialization(MorphiaConfig config, PropertyModelBuilder property) {
        this.config = config;
        this.annotations = property.annotations();
        this.modifiers = property.modifiers();
    }

    public boolean shouldSerialize(@Nullable Object value) {
        if (!this.config.storeNulls().booleanValue() && value == null) {
            return false;
        }
        if (this.config.ignoreFinals().booleanValue() && Modifier.isFinal(this.modifiers)) {
            return false;
        }
        if (!this.config.storeEmpties().booleanValue() && (value instanceof Map && ((Map)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty())) {
            return false;
        }
        return this.doesNotHaveAnnotation(LoadOnly.class) && this.doesNotHaveAnnotation(NotSaved.class);
    }

    private boolean doesNotHaveAnnotation(Class<? extends Annotation> annotationClass) {
        return this.annotations.stream().noneMatch(a -> a.annotationType().equals(annotationClass));
    }
}

