/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.CollectionPropertyCodecProvider;
import dev.morphia.mapping.codec.EnumPropertyCodecProvider;
import dev.morphia.mapping.codec.MorphiaCollectionPropertyCodecProvider;
import java.util.ArrayList;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.codecs.pojo.TypeWithTypeParameters;

@MorphiaInternal
public class PropertyCodecRegistryImpl
implements PropertyCodecRegistry {
    private final List<PropertyCodecProvider> propertyCodecProviders;

    public PropertyCodecRegistryImpl(Codec<?> pojoCodec, CodecRegistry codecRegistry, List<PropertyCodecProvider> propertyCodecProviders) {
        ArrayList<PropertyCodecProvider> augmentedProviders = new ArrayList<PropertyCodecProvider>(propertyCodecProviders);
        augmentedProviders.add(new CollectionPropertyCodecProvider());
        augmentedProviders.add(new MorphiaCollectionPropertyCodecProvider());
        augmentedProviders.add(new EnumPropertyCodecProvider(codecRegistry));
        augmentedProviders.add(new FallbackPropertyCodecProvider(pojoCodec, codecRegistry));
        this.propertyCodecProviders = augmentedProviders;
    }

    public <S> Codec<S> get(TypeWithTypeParameters<S> type) {
        for (PropertyCodecProvider propertyCodecProvider : this.propertyCodecProviders) {
            Codec codec = propertyCodecProvider.get(type, (PropertyCodecRegistry)this);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }

    private static final class FallbackPropertyCodecProvider
    implements PropertyCodecProvider {
        private final CodecRegistry codecRegistry;
        private final Codec<?> codec;

        FallbackPropertyCodecProvider(Codec<?> codec, CodecRegistry codecRegistry) {
            this.codec = codec;
            this.codecRegistry = codecRegistry;
        }

        public <S> Codec<S> get(TypeWithTypeParameters<S> type, PropertyCodecRegistry propertyCodecRegistry) {
            Class clazz = type.getType();
            if (clazz == this.codec.getEncoderClass()) {
                return this.codec;
            }
            return this.codecRegistry.get(type.getType());
        }
    }
}

