/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import dev.morphia.Datastore;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

class TypedArrayCodec
implements Codec {
    private final Class type;
    private Codec codec;
    private Datastore datastore;

    TypedArrayCodec(Datastore datastore, Class type) {
        this.datastore = datastore;
        this.type = type;
    }

    public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
        writer.writeStartArray();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(value, i);
            if (element == null) {
                writer.writeNull();
                continue;
            }
            this.getCodec().encode(writer, element, encoderContext);
        }
        writer.writeEndArray();
    }

    public Class getEncoderClass() {
        return Array.newInstance(this.type, 0).getClass();
    }

    private Codec getCodec() {
        if (this.codec == null) {
            this.codec = this.datastore.getCodecRegistry().get(this.type);
        }
        return this.codec;
    }

    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.getCodec().decode(reader, decoderContext));
        }
        reader.readEndArray();
        Object array = Array.newInstance(this.type, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    public String toString() {
        return String.format("%s<%s>", this.getClass().getName(), this.type.getSimpleName());
    }
}

