/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import java.net.MalformedURLException;
import java.net.URI;
import org.bson.BSONException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class URICodec
implements Codec<URI> {
    public URI decode(BsonReader reader, DecoderContext decoderContext) {
        return URI.create(reader.readString());
    }

    public void encode(BsonWriter writer, URI value, EncoderContext encoderContext) {
        try {
            writer.writeString(value.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new BSONException("Could not serialize the URI: " + value);
        }
    }

    public Class<URI> getEncoderClass() {
        return URI.class;
    }
}

