/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.DiscriminatorLookup;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonType;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class EntityDecoder<T>
implements Decoder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDecoder.class);
    private final MorphiaCodec<T> morphiaCodec;
    private final EntityModel classModel;

    protected EntityDecoder(MorphiaCodec<T> morphiaCodec) {
        this.morphiaCodec = morphiaCodec;
        this.classModel = morphiaCodec.getEntityModel();
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        if (decoderContext.hasCheckedDiscriminator()) {
            LOG.debug(String.format("Decoding document using codec for %s'", this.morphiaCodec.getEntityModel().getType().getName()));
            MorphiaInstanceCreator instanceCreator = this.getInstanceCreator();
            this.decodeProperties(reader, decoderContext, instanceCreator, this.classModel);
            return (T)instanceCreator.getInstance();
        }
        Object entity = this.getCodecFromDocument(reader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.morphiaCodec.getRegistry(), this.morphiaCodec.getDiscriminatorLookup(), (Codec<T>)this.morphiaCodec).decode(reader, DecoderContext.builder().checkedDiscriminator(true).build());
        return (T)entity;
    }

    protected void decodeModel(BsonReader reader, DecoderContext decoderContext, MorphiaInstanceCreator instanceCreator, @Nullable PropertyModel model) {
        block5: {
            if (model != null) {
                BsonReaderMark mark = reader.getMark();
                try {
                    if (reader.getCurrentBsonType() == BsonType.NULL) {
                        reader.readNull();
                        break block5;
                    }
                    Object value = decoderContext.decodeWithChildContext(model.getCodec(), reader);
                    instanceCreator.set(value, model);
                }
                catch (BsonInvalidOperationException e) {
                    mark.reset();
                    Object value = this.morphiaCodec.getDatastore().getCodecRegistry().get(Object.class).decode(reader, decoderContext);
                    instanceCreator.set(Conversions.convert(value, model.getTypeData().getType()), model);
                }
            } else {
                reader.skipValue();
            }
        }
    }

    protected void decodeProperties(BsonReader reader, DecoderContext decoderContext, MorphiaInstanceCreator instanceCreator, EntityModel classModel) {
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String name = reader.readName();
            if (classModel.useDiscriminator() && classModel.getDiscriminatorKey().equals(name)) {
                reader.readString();
                continue;
            }
            this.decodeModel(reader, decoderContext, instanceCreator, classModel.getProperty(name));
        }
        reader.readEndDocument();
    }

    protected Codec<T> getCodecFromDocument(BsonReader reader, boolean useDiscriminator, String discriminatorKey, CodecRegistry registry, DiscriminatorLookup discriminatorLookup, Codec<T> defaultCodec) {
        Codec codec = null;
        if (useDiscriminator) {
            BsonReaderMark mark = reader.getMark();
            try {
                reader.readStartDocument();
                while (codec == null && reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    if (discriminatorKey.equals(reader.readName())) {
                        codec = registry.get(discriminatorLookup.lookup(reader.readString()));
                        continue;
                    }
                    reader.skipValue();
                }
            }
            catch (Exception e) {
                throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding errored with: %s", this.morphiaCodec.getEntityModel().getName(), e.getMessage()), (Throwable)e);
            }
            finally {
                mark.reset();
            }
        }
        return codec != null ? codec : defaultCodec;
    }

    protected MorphiaInstanceCreator getInstanceCreator() {
        return this.classModel.getInstanceCreator();
    }

    protected MorphiaCodec<T> getMorphiaCodec() {
        return this.morphiaCodec;
    }
}

