/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.EntityListener;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.EntityListeners;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.ShardKeys;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.InstanceCreatorFactory;
import dev.morphia.mapping.InstanceCreatorFactoryImpl;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.lifecycle.EntityListenerAdapter;
import dev.morphia.mapping.lifecycle.OnEntityListenerAdapter;
import dev.morphia.mapping.lifecycle.UntypedEntityListenerAdapter;
import dev.morphia.sofia.Sofia;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class EntityModel {
    private static final Logger LOG = LoggerFactory.getLogger(EntityModel.class);
    private final Map<Class<? extends Annotation>, Annotation> annotations;
    private final Map<String, PropertyModel> propertyModelsByName;
    private final Map<String, PropertyModel> propertyModelsByMappedName;
    private final List<PropertyModel> shardKeys;
    private final InstanceCreatorFactory creatorFactory;
    private final boolean discriminatorEnabled;
    private final String discriminatorKey;
    private final String discriminator;
    private final Class<?> type;
    private final String collectionName;
    public final Set<EntityModel> subtypes = new CopyOnWriteArraySet<EntityModel>();
    public EntityModel superClass;
    private final PropertyModel idProperty;
    private final PropertyModel versionProperty;
    private final List<EntityListener<?>> listeners = new ArrayList();

    EntityModel(EntityModelBuilder builder) {
        this.type = builder.targetType();
        if (!Modifier.isStatic(this.type.getModifiers()) && this.type.isMemberClass()) {
            throw new MappingException(Sofia.noInnerClasses(this.type.getName(), new Locale[0]));
        }
        this.superClass = builder.superclass();
        this.discriminatorEnabled = builder.isDiscriminatorEnabled();
        this.discriminatorKey = builder.discriminatorKey();
        this.discriminator = builder.discriminator();
        this.annotations = builder.annotations();
        this.propertyModelsByName = new LinkedHashMap<String, PropertyModel>();
        this.propertyModelsByMappedName = new LinkedHashMap<String, PropertyModel>();
        builder.propertyModels().forEach(modelBuilder -> {
            PropertyModel model = modelBuilder.owner(this).build();
            this.propertyModelsByMappedName.put(model.getMappedName(), model);
            for (String name : modelBuilder.alternateNames()) {
                if (this.propertyModelsByMappedName.put(name, model) == null) continue;
                throw new MappingException(Sofia.duplicatedMappedName(this.type.getCanonicalName(), name, new Locale[0]));
            }
            this.propertyModelsByName.putIfAbsent(model.getName(), model);
        });
        ShardKeys shardKeys = this.getAnnotation(ShardKeys.class);
        this.shardKeys = shardKeys != null ? Arrays.stream(shardKeys.value()).map(k -> this.getProperty(k.value())).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        this.collectionName = builder.getCollectionName();
        this.creatorFactory = new InstanceCreatorFactoryImpl(this);
        if (this.superClass != null) {
            this.superClass.addSubtype(this);
        }
        this.idProperty = this.getProperty(builder.idPropertyName());
        this.versionProperty = this.getProperty(builder.versionPropertyName());
        builder.interfaces().forEach(i -> i.addSubtype(this));
        EntityListeners entityLisAnn = this.getAnnotation(EntityListeners.class);
        if (entityLisAnn != null) {
            for (Class<?> aClass : entityLisAnn.value()) {
                if (EntityListener.class.isAssignableFrom(aClass)) {
                    this.listeners.add(new EntityListenerAdapter(aClass));
                    continue;
                }
                this.listeners.add(new UntypedEntityListenerAdapter(aClass));
            }
        }
        this.listeners.add(new OnEntityListenerAdapter(this.getType()));
    }

    public EntityModel(EntityModel other) {
        this.type = other.type;
        this.discriminatorEnabled = other.discriminatorEnabled;
        this.discriminatorKey = other.discriminatorKey;
        this.discriminator = other.discriminator;
        this.annotations = other.annotations;
        this.propertyModelsByName = new LinkedHashMap<String, PropertyModel>();
        this.propertyModelsByMappedName = new LinkedHashMap<String, PropertyModel>();
        other.propertyModelsByName.values().forEach(otherProperty -> {
            PropertyModel model = new PropertyModel(this, (PropertyModel)otherProperty);
            this.propertyModelsByMappedName.put(model.getMappedName(), model);
            List<String> loadNames = model.getLoadNames();
            for (int i = 1; i < loadNames.size(); ++i) {
                String name = loadNames.get(i);
                if (this.propertyModelsByMappedName.put(name, model) == null) continue;
                throw new MappingException(Sofia.duplicatedMappedName(this.type.getCanonicalName(), name, new Locale[0]));
            }
            this.propertyModelsByName.putIfAbsent(model.getName(), model);
        });
        ShardKeys shardKeys = this.getAnnotation(ShardKeys.class);
        this.shardKeys = shardKeys != null ? Arrays.stream(shardKeys.value()).map(k -> this.getProperty(k.value())).filter(Objects::nonNull).collect(Collectors.toList()) : Collections.emptyList();
        this.collectionName = other.collectionName;
        this.creatorFactory = new InstanceCreatorFactoryImpl(this);
        PropertyModel otherId = other.idProperty;
        this.idProperty = otherId != null ? this.getProperty(otherId.getName()) : null;
        PropertyModel otherVersion = other.versionProperty;
        this.versionProperty = otherVersion != null ? this.getProperty(otherVersion.getName()) : null;
        EntityListeners entityLisAnn = this.getAnnotation(EntityListeners.class);
        if (entityLisAnn != null) {
            for (Class<?> aClass : entityLisAnn.value()) {
                if (EntityListener.class.isAssignableFrom(aClass)) {
                    this.listeners.add(new EntityListenerAdapter(aClass));
                    continue;
                }
                this.listeners.add(new UntypedEntityListenerAdapter(aClass));
            }
        }
        this.listeners.add(new OnEntityListenerAdapter(this.getType()));
    }

    public void callLifecycleMethods(Class<? extends Annotation> event, Object entity, Document document, Datastore datastore) {
        this.listeners.forEach(listener -> this.invokeLifecycleEvent(event, entity, document, datastore, (EntityListener)listener));
        datastore.getMapper().getInterceptors().forEach(listener -> {
            LOG.debug(Sofia.callingInterceptorMethod(event.getSimpleName(), listener, new Locale[0]));
            this.invokeLifecycleEvent(event, entity, document, datastore, (EntityListener)listener);
        });
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return (A)this.annotations.get(clazz);
    }

    @NonNull
    public String getCollectionName() {
        if (this.collectionName == null) {
            throw new MappingException(Sofia.noMappedCollection(this.getType().getName(), new Locale[0]));
        }
        return this.collectionName;
    }

    public List<PropertyModel> getShardKeys() {
        return this.shardKeys;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    @Nullable
    public Embedded getEmbeddedAnnotation() {
        return this.getAnnotation(Embedded.class);
    }

    @Nullable
    public Entity getEntityAnnotation() {
        return this.getAnnotation(Entity.class);
    }

    @Nullable
    public PropertyModel getIdProperty() {
        return this.idProperty;
    }

    public MorphiaInstanceCreator getInstanceCreator() {
        return this.creatorFactory.create();
    }

    public String getName() {
        return this.type.getSimpleName();
    }

    public List<PropertyModel> getProperties(Class<? extends Annotation> type) {
        return this.propertyModelsByName.values().stream().filter(model -> model.hasAnnotation(type)).collect(Collectors.toList());
    }

    public List<PropertyModel> getProperties() {
        return new ArrayList<PropertyModel>(this.propertyModelsByName.values());
    }

    @Nullable
    public PropertyModel getProperty(@Nullable String name) {
        return name != null ? this.propertyModelsByMappedName.getOrDefault(name, this.propertyModelsByName.get(name)) : null;
    }

    @Nullable
    public EntityModel getSubtype(Class<?> type) {
        return this.subtypes.stream().filter(subtype -> subtype.type.equals(type)).findFirst().orElse(null);
    }

    public Set<EntityModel> getSubtypes() {
        return this.subtypes;
    }

    @Nullable
    public EntityModel getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(@Nullable EntityModel model) {
        this.superClass = model;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Nullable
    public PropertyModel getVersionProperty() {
        return this.versionProperty;
    }

    public boolean hasLifecycle(Class<? extends Annotation> type) {
        return this.listeners.stream().anyMatch(listener -> listener.hasAnnotation(type));
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.propertyModelsByName, this.propertyModelsByMappedName, this.creatorFactory, this.discriminatorEnabled, this.getDiscriminatorKey(), this.getDiscriminator(), this.getType(), this.getCollectionName(), this.listeners);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityModel)) {
            return false;
        }
        EntityModel that = (EntityModel)o;
        return this.discriminatorEnabled == that.discriminatorEnabled && Objects.equals(this.annotations, that.annotations) && Objects.equals(this.propertyModelsByName, that.propertyModelsByName) && Objects.equals(this.propertyModelsByMappedName, that.propertyModelsByMappedName) && Objects.equals(this.creatorFactory, that.creatorFactory) && Objects.equals(this.getDiscriminatorKey(), that.getDiscriminatorKey()) && Objects.equals(this.getDiscriminator(), that.getDiscriminator()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getCollectionName(), that.getCollectionName()) && Objects.equals(this.listeners, that.listeners);
    }

    public String toString() {
        String properties = this.propertyModelsByName.values().stream().map(PropertyModel::toString).collect(Collectors.joining(", "));
        return String.format("%s<%s> { %s } ", EntityModel.class.getSimpleName(), this.type.getSimpleName(), properties);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getType().getModifiers());
    }

    public boolean isInterface() {
        return this.getType().isInterface();
    }

    public boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public void addSubtype(EntityModel entityModel) {
        this.subtypes.add(entityModel);
        if (this.superClass != null) {
            this.superClass.addSubtype(entityModel);
        }
    }

    private void invokeLifecycleEvent(Class<? extends Annotation> event, Object entity, Document document, Datastore datastore, EntityListener ei) {
        if (event.equals(PreLoad.class)) {
            ei.preLoad(entity, document, datastore);
        } else if (event.equals(PostLoad.class)) {
            ei.postLoad(entity, document, datastore);
        } else if (event.equals(PrePersist.class)) {
            ei.prePersist(entity, document, datastore);
        } else if (event.equals(PostPersist.class)) {
            ei.postPersist(entity, document, datastore);
        }
    }
}

