/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.ConfigureProperties;
import dev.morphia.mapping.conventions.FieldDiscovery;
import dev.morphia.mapping.conventions.MethodDiscovery;
import dev.morphia.mapping.conventions.MorphiaConvention;
import dev.morphia.mapping.conventions.MorphiaDefaultsConvention;
import dev.morphia.sofia.Sofia;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

@MorphiaInternal
public class EntityModelBuilder {
    private final List<PropertyModelBuilder> propertyModels = new ArrayList<PropertyModelBuilder>();
    private final List<PropertyModelBuilder> shardKeys = new ArrayList<PropertyModelBuilder>();
    private final List<EntityModel> interfaceModels = new ArrayList<EntityModel>();
    private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Set<Class<?>> interfaces = new LinkedHashSet();
    private final Map<String, Map<String, Type>> parameterization = new LinkedHashMap<String, Map<String, Type>>();
    private final Mapper mapper;
    private final Class<?> type;
    private Class<?> targetType;
    private boolean discriminatorEnabled;
    private String discriminator;
    private String discriminatorKey;
    private String idPropertyName;
    private String versionPropertyName;
    private EntityModel superclass;

    public EntityModelBuilder(Mapper mapper, Class<?> type) {
        this.mapper = mapper;
        this.type = type;
        this.targetType = type;
        if (type.getSuperclass() != null) {
            try {
                this.superclass = mapper.getEntityModel(type.getSuperclass());
            }
            catch (NotMappableException notMappableException) {
                // empty catch block
            }
        }
        this.buildHierarchy(this.type);
        this.parameterization.putAll(this.findParameterization(type));
        this.propagateTypes();
        this.interfaces.stream().map(i -> {
            try {
                return mapper.getEntityModel((Class)i);
            }
            catch (NotMappableException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> this.interfaceModels));
    }

    public PropertyModelBuilder addProperty() {
        PropertyModelBuilder builder = PropertyModel.builder(this.mapper);
        this.propertyModels.add(builder);
        return builder;
    }

    public EntityModelBuilder annotation(Annotation type) {
        this.annotations.putIfAbsent(type.annotationType(), type);
        return this;
    }

    public EntityModel build() {
        ArrayList<ConfigureProperties> conventions = new ArrayList<ConfigureProperties>(List.of(new MorphiaDefaultsConvention(), this.mapper.getConfig().propertyDiscovery() == MapperOptions.PropertyDiscovery.FIELDS ? new FieldDiscovery() : new MethodDiscovery(), new ConfigureProperties()));
        ServiceLoader.load(MorphiaConvention.class).forEach(conventions::add);
        for (MorphiaConvention morphiaConvention : conventions) {
            morphiaConvention.apply(this.mapper, this);
        }
        if (this.discriminatorEnabled) {
            Objects.requireNonNull(this.discriminatorKey, Sofia.notNull("discriminatorKey", new Locale[0]));
            Objects.requireNonNull(this.discriminator, Sofia.notNull("discriminator", new Locale[0]));
        }
        return new EntityModel(this);
    }

    public Set<Class<?>> classHierarchy() {
        return this.classes;
    }

    public EntityModelBuilder discriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public String discriminator() {
        return this.discriminator;
    }

    public EntityModelBuilder discriminatorKey(String key) {
        this.discriminatorKey = key;
        return this;
    }

    public String discriminatorKey() {
        return this.discriminatorKey;
    }

    public EntityModelBuilder enableDiscriminator(boolean enabled) {
        this.discriminatorEnabled = enabled;
        return this;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> type) {
        return (A)this.annotations.get(type);
    }

    public TypeData<?> getTypeData(Class<?> type, TypeData<?> suggested, Type genericType) {
        Type mapped;
        Map<String, Type> map;
        if (genericType instanceof TypeVariable && (map = this.parameterization.get(type.getName())) != null && (mapped = map.get(((TypeVariable)genericType).getName())) != null) {
            suggested = TypeData.get(mapped);
        }
        return suggested;
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.annotations.containsKey(type);
    }

    @Nullable
    public String idPropertyName() {
        return this.idPropertyName;
    }

    public EntityModelBuilder idPropertyName(String name) {
        this.idPropertyName = name;
        return this;
    }

    public List<EntityModel> interfaces() {
        return this.interfaceModels;
    }

    public boolean isDiscriminatorEnabled() {
        return this.discriminatorEnabled;
    }

    public PropertyModelBuilder propertyModelByName(String name) throws NoSuchElementException {
        return this.propertyModels.stream().filter(f -> f.name().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No property found named %s.  Valid names are: %s", name, this.propertyModels.stream().map(p -> p.name()).collect(Collectors.toList()))));
    }

    public List<PropertyModelBuilder> propertyModels() {
        return this.propertyModels;
    }

    @Nullable
    public EntityModel superclass() {
        return this.superclass;
    }

    public Class<?> targetType() {
        return this.targetType;
    }

    public EntityModelBuilder targetType(Class<?> targetType) {
        this.targetType = targetType;
        return this;
    }

    public Class<?> type() {
        return this.type;
    }

    @Nullable
    public String versionPropertyName() {
        return this.versionPropertyName;
    }

    public EntityModelBuilder versionPropertyName(String name) {
        this.versionPropertyName = name;
        return this;
    }

    protected Map<Class<? extends Annotation>, Annotation> annotations() {
        return this.annotations;
    }

    protected String getCollectionName() {
        Entity entityAn = this.getAnnotation(Entity.class);
        return entityAn != null && !entityAn.value().equals(".") ? entityAn.value() : this.mapper.getConfig().collectionNaming().apply(this.targetType.getSimpleName());
    }

    private void buildHierarchy(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            this.annotation(annotation);
        }
        this.interfaces.addAll(this.findInterfaces(type));
        this.classes.addAll(this.findParentClasses(type.getSuperclass()));
        this.classes.forEach(c -> this.interfaces.addAll(this.findInterfaces((Class<?>)c)));
    }

    private List<? extends Class<?>> findInterfaces(Class<?> type) {
        ArrayList list = new ArrayList();
        List<Class<?>> interfaces = Arrays.asList(type.getInterfaces());
        for (Annotation annotation : type.getAnnotations()) {
            this.annotation(annotation);
        }
        list.addAll(interfaces);
        list.addAll(interfaces.stream().flatMap(i -> this.findInterfaces((Class<?>)i).stream()).collect(Collectors.toList()));
        return list;
    }

    private Map<String, Map<String, Type>> findParameterization(Class<?> type) {
        if (type.getSuperclass() == null) {
            return new LinkedHashMap<String, Map<String, Type>>();
        }
        Map<String, Map<String, Type>> parentMap = this.findParameterization(type.getSuperclass());
        Map<String, Type> typeMap = this.mapArguments(type.getSuperclass(), type.getGenericSuperclass());
        parentMap.put(type.getSuperclass().getName(), typeMap);
        return parentMap;
    }

    private Set<Class<?>> findParentClasses(Class<?> type) {
        LinkedHashSet classes = new LinkedHashSet();
        while (type != null && !type.isEnum() && !type.equals(Object.class)) {
            classes.add(type);
            for (Annotation annotation : type.getAnnotations()) {
                this.annotation(annotation);
            }
            type = type.getSuperclass();
        }
        return classes;
    }

    private Map<String, Type> mapArguments(@Nullable Class<?> type, Type typeSignature) {
        TypeVariable<Class<?>>[] typeParameters;
        HashMap<String, Type> map = new HashMap<String, Type>();
        if (type != null && typeSignature instanceof ParameterizedType && (typeParameters = type.getTypeParameters()).length != 0) {
            Type[] arguments = ((ParameterizedType)typeSignature).getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                TypeVariable<Class<?>> typeParameter = typeParameters[i];
                map.put(typeParameter.getName(), arguments[i]);
            }
        }
        return map;
    }

    private void propagateTypes() {
        ArrayList<Map<String, Type>> parameters = new ArrayList<Map<String, Type>>(this.parameterization.values());
        for (int index = 0; index < parameters.size(); ++index) {
            Map current = (Map)parameters.get(index);
            if (index + 1 >= parameters.size()) continue;
            for (Map.Entry entry : current.entrySet()) {
                int peek = index + 1;
                while (entry.getValue() instanceof TypeVariable && peek < parameters.size()) {
                    TypeVariable typeVariable = (TypeVariable)entry.getValue();
                    Map next = (Map)parameters.get(peek++);
                    entry.setValue((Type)next.get(typeVariable.getName()));
                }
            }
        }
    }

    public String toString() {
        return "EntityModelBuilder" + "<" + this.type.getSimpleName() + '>';
    }
}

