/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.Datastore;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.pojo.EntityEncoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class LifecycleEncoder<T>
extends EntityEncoder<T> {
    public LifecycleEncoder(MorphiaCodec<T> morphiaCodec) {
        super(morphiaCodec);
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        EntityModel model = this.getMorphiaCodec().getEntityModel();
        Datastore datastore = this.getMorphiaCodec().getDatastore();
        Document document = new Document();
        model.callLifecycleMethods(PrePersist.class, value, document, datastore);
        DocumentWriter documentWriter = new DocumentWriter(datastore.getMapper().getConfig(), document);
        super.encode(documentWriter, value, encoderContext);
        document = documentWriter.getDocument();
        model.callLifecycleMethods(PostPersist.class, value, document, datastore);
        this.getMorphiaCodec().getRegistry().get(Document.class).encode(writer, (Object)document, encoderContext);
    }
}

