/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.LoadOnly;
import dev.morphia.annotations.NotSaved;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.pojo.EntityEncoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.Query;
import dev.morphia.query.Update;
import dev.morphia.query.UpdateException;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.query.updates.UpdateOperators;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class MergingEncoder<T>
extends EntityEncoder {
    private final Query<T> query;
    private final DocumentWriter setOperations;
    private Update<T> update;

    @MorphiaInternal
    public MergingEncoder(Query<T> query, MorphiaCodec<T> morphiaCodec) {
        super(morphiaCodec);
        this.query = query;
        this.setOperations = new DocumentWriter(morphiaCodec.getMapper().getConfig());
    }

    public Update<T> encode(Object entity) {
        this.encode(this.setOperations, entity, EncoderContext.builder().build());
        for (Map.Entry entry : this.setOperations.getDocument().entrySet()) {
            this.add(UpdateOperators.set((String)entry.getKey(), entry.getValue()));
        }
        if (this.update == null) {
            throw new UpdateException("Nothing to update");
        }
        return this.update;
    }

    @Override
    protected void encodeDiscriminator(BsonWriter writer, EntityModel model) {
    }

    @Override
    protected void encodeIdProperty(BsonWriter writer, Object instance, EncoderContext encoderContext, @Nullable PropertyModel idModel) {
    }

    @Override
    protected void encodeValue(BsonWriter writer, EncoderContext encoderContext, PropertyModel model, @Nullable Object value) {
        super.encodeValue(writer, encoderContext, model, value);
        if (!(model.shouldSerialize(value) || model.hasAnnotation(LoadOnly.class) || model.hasAnnotation(NotSaved.class))) {
            this.add(UpdateOperators.unset(model.getMappedName()));
        }
    }

    private void add(UpdateOperator operator) {
        if (this.update == null) {
            this.update = this.query.update(operator, new UpdateOperator[0]);
        } else {
            this.update.add(operator);
        }
    }
}

