/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.Datastore;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.DiscriminatorLookup;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.PropertyCodecRegistryImpl;
import dev.morphia.mapping.codec.pojo.EntityDecoder;
import dev.morphia.mapping.codec.pojo.EntityEncoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.PropertyCodecRegistry;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
public class MorphiaCodec<T>
implements CollectibleCodec<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MorphiaCodec.class);
    private final PropertyModel idProperty;
    private final EntityModel entityModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final DiscriminatorLookup discriminatorLookup;
    private EntityEncoder<T> encoder;
    private EntityDecoder<T> decoder;
    private Datastore datastore;

    public MorphiaCodec(Datastore datastore, EntityModel model, List<PropertyCodecProvider> propertyCodecProviders, DiscriminatorLookup discriminatorLookup, CodecRegistry registry) {
        this.datastore = datastore;
        this.discriminatorLookup = discriminatorLookup;
        this.entityModel = model;
        this.registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{this}), registry});
        this.propertyCodecRegistry = new PropertyCodecRegistryImpl((Codec<?>)this, registry, propertyCodecProviders);
        this.idProperty = model.getIdProperty();
        this.specializePropertyCodecs();
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.getDecoder().decode(reader, decoderContext);
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.getEncoder().encode(writer, value, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.getEntityModel().getType();
    }

    public Object generateIdIfAbsentFromDocument(Object entity) {
        if (!this.documentHasId(entity) && this.idProperty != null) {
            if (ObjectId.class.equals(this.idProperty.getType()) || String.class.equals(this.idProperty.getType())) {
                this.idProperty.setValue(entity, Conversions.convert(new ObjectId(), this.idProperty.getType()));
            } else {
                LOG.warn(Sofia.noIdAndNotObjectId(entity.getClass().getName(), new Locale[0]));
            }
        }
        return entity;
    }

    public boolean documentHasId(Object entity) {
        if (this.idProperty == null) {
            throw new MappingException(Sofia.idRequired(entity.getClass().getName(), new Locale[0]));
        }
        return this.idProperty.getValue(entity) != null;
    }

    public BsonValue getDocumentId(Object document) {
        throw new UnsupportedOperationException();
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public DiscriminatorLookup getDiscriminatorLookup() {
        return this.discriminatorLookup;
    }

    public EntityEncoder<T> getEncoder() {
        if (this.encoder == null) {
            this.encoder = new EntityEncoder(this);
        }
        return this.encoder;
    }

    public MorphiaCodec<T> setEncoder(EntityEncoder<T> encoder) {
        this.encoder = encoder;
        return this;
    }

    public EntityModel getEntityModel() {
        return this.entityModel;
    }

    public Mapper getMapper() {
        return this.getDatastore().getMapper();
    }

    public CodecRegistry getRegistry() {
        return this.registry;
    }

    protected EntityDecoder<T> getDecoder() {
        if (this.decoder == null) {
            this.decoder = new EntityDecoder(this);
        }
        return this.decoder;
    }

    public MorphiaCodec<T> setDecoder(EntityDecoder<T> decoder) {
        this.decoder = decoder;
        return this;
    }

    private void specializePropertyCodecs() {
        EntityModel entityModel = this.getEntityModel();
        for (PropertyModel propertyModel : entityModel.getProperties()) {
            Codec specializeCodec = propertyModel.specializeCodec(this.getDatastore());
            Codec codec = specializeCodec != null ? specializeCodec : this.propertyCodecRegistry.get(propertyModel.getTypeData());
            if (codec == null) continue;
            propertyModel.codec((Codec<? super Object>)codec);
        }
    }
}

