/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Version;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.MorphiaPropertySerialization;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.PropertyAccessor;

@MorphiaInternal
public final class PropertyModelBuilder {
    private final List<String> alternateNames = new ArrayList<String>();
    private final Mapper mapper;
    private PropertyAccessor<? super Object> accessor;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private Boolean discriminatorEnabled;
    private EntityModel owner;
    private String mappedName;
    private int modifiers;
    private String name;
    private TypeData<?> typeData;
    private MorphiaPropertySerialization serialization;

    PropertyModelBuilder(Mapper mapper) {
        this.mapper = mapper;
    }

    public PropertyAccessor<? super Object> accessor() {
        return this.accessor;
    }

    public PropertyModelBuilder accessor(PropertyAccessor<? super Object> accessor) {
        this.accessor = accessor;
        return this;
    }

    public void alternateName(String name) {
        this.alternateNames.add(name);
    }

    public List<String> alternateNames() {
        return this.alternateNames;
    }

    public PropertyModelBuilder annotation(Annotation annotation) {
        this.annotations.add((Annotation)Assertions.notNull((String)"annotation", (Object)annotation));
        return this;
    }

    public PropertyModelBuilder annotations(List<Annotation> annotations) {
        this.annotations = Collections.unmodifiableList((List)Assertions.notNull((String)"annotations", annotations));
        return this;
    }

    public List<Annotation> annotations() {
        return this.annotations;
    }

    public PropertyModel build() {
        return new PropertyModel(this);
    }

    @MorphiaInternal
    public PropertyModelBuilder discoverMappedName() {
        MorphiaConfig config = this.mapper.getConfig();
        Property property = this.getAnnotation(Property.class);
        Reference reference = this.getAnnotation(Reference.class);
        Version version = this.getAnnotation(Version.class);
        if (this.hasAnnotation(Id.class)) {
            this.mappedName("_id");
        } else if (property != null && !property.value().equals(".")) {
            this.mappedName(property.value());
        } else if (reference != null && !reference.value().equals(".")) {
            this.mappedName(reference.value());
        } else if (version != null && !version.value().equals(".")) {
            this.mappedName(version.value());
        } else {
            this.mappedName(config.propertyNaming().apply(this.name()));
        }
        return this;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> type) {
        for (Annotation annotation : this.annotations) {
            if (!type.equals(annotation.annotationType())) continue;
            return (A)((Annotation)type.cast(annotation));
        }
        return null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        for (Annotation annotation : this.annotations) {
            if (!type.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public PropertyModelBuilder mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PropertyModelBuilder discriminatorEnabled(Boolean discriminatorEnabled) {
        this.discriminatorEnabled = discriminatorEnabled;
        return this;
    }

    public Boolean discriminatorEnabled() {
        return this.discriminatorEnabled;
    }

    public String mappedName() {
        return this.mappedName;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public PropertyModelBuilder modifiers(int modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public PropertyModelBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PropertyModelBuilder owner(EntityModel entityModel) {
        this.owner = entityModel;
        return this;
    }

    public EntityModel owner() {
        return this.owner;
    }

    public PropertyModelBuilder serialization(MorphiaPropertySerialization propertySerialization) {
        this.serialization = (MorphiaPropertySerialization)Assertions.notNull((String)"propertySerialization", (Object)propertySerialization);
        return this;
    }

    public MorphiaPropertySerialization serialization() {
        return this.serialization;
    }

    public String toString() {
        return new StringJoiner(", ", PropertyModelBuilder.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("mappedName='" + this.mappedName + "'").add("typeData=" + this.typeData).add("annotations=" + this.annotations).toString();
    }

    public TypeData<?> typeData() {
        return this.typeData;
    }

    public PropertyModelBuilder typeData(TypeData<?> typeData) {
        this.typeData = (TypeData)Assertions.notNull((String)"typeData", typeData);
        return this;
    }
}

