/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.pojo.WildCardTypeData;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Spliterator;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.TypeWithTypeParameters;

@MorphiaInternal
public class TypeData<T>
implements TypeWithTypeParameters<T> {
    private final Class<T> type;
    private final List<TypeData<?>> typeParameters = new ArrayList();
    private boolean array;

    public TypeData(Class<T> type) {
        this.type = type;
    }

    public TypeData(Class<T> type, List<TypeData<?>> typeParameters) {
        this.type = type;
        this.typeParameters.addAll(typeParameters);
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder((Class)Assertions.notNull((String)"type", type));
    }

    public static TypeData<?> get(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            TypeParameters parameters = TypeParameters.of(pType);
            Builder paramBuilder = TypeData.builder((Class)pType.getRawType());
            for (Type argType : parameters) {
                paramBuilder.addTypeParameter(TypeData.get(argType));
            }
            return paramBuilder.build();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            Type[] bounds = upperBounds != null ? upperBounds : wildcardType.getLowerBounds();
            return new WildCardTypeData(TypeData.get(bounds[0]), upperBounds != null);
        }
        if (type instanceof TypeVariable) {
            return TypeData.builder(Object.class).build();
        }
        if (type instanceof Class) {
            TypeData typeData = new TypeData((Class)type);
            for (Type argType : TypeParameters.of(type)) {
                typeData.typeParameters.add((TypeData<?>)(argType.equals(type) ? type : TypeData.get(argType)));
            }
            return typeData;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            TypeData<?> typeData = TypeData.get(arrayType.getGenericComponentType());
            typeData.setArray(true);
            return typeData;
        }
        throw new UnsupportedOperationException(Sofia.unhandledTypeData(type.getClass(), new Locale[0]));
    }

    private static String nestedTypeParameters(List<TypeData<?>> typeParameters) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int last = typeParameters.size();
        for (TypeData<?> typeParameter : typeParameters) {
            ++count;
            builder.append(typeParameter.getType().getSimpleName());
            if (!typeParameter.getTypeParameters().isEmpty()) {
                builder.append(String.format("<%s>", TypeData.nestedTypeParameters(typeParameter.getTypeParameters())));
            }
            if (count >= last) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static TypeData<?> get(Field field) {
        return TypeData.get(field.getGenericType());
    }

    public static TypeData<?> get(Method method) {
        return TypeData.newInstance(method.getGenericReturnType());
    }

    public static <T> TypeData<T> newInstance(Type genericType) {
        return TypeData.get(genericType);
    }

    public boolean getArray() {
        return this.array;
    }

    public Class<T> getType() {
        return this.type;
    }

    public List<TypeData<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getTypeParameters().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeData)) {
            return false;
        }
        TypeData that = (TypeData)o;
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public String toString() {
        Object value = this.type.getSimpleName();
        if (!this.typeParameters.isEmpty()) {
            StringJoiner joiner = new StringJoiner(", ", "<", ">");
            this.typeParameters.forEach(t -> joiner.add(t.toString()));
            value = (String)value + joiner;
        }
        return value;
    }

    public TypeData<?> withType(Class<?> concreteClass) {
        return new TypeData(concreteClass, new ArrayList(this.typeParameters));
    }

    public static final class Builder<T> {
        private final Class<T> type;
        private final List<TypeData<?>> typeParameters = new ArrayList();

        private Builder(Class<T> type) {
            this.type = type;
        }

        public <S> Builder<T> addTypeParameter(TypeData<S> typeParameter) {
            this.typeParameters.add((TypeData)Assertions.notNull((String)"typeParameter", typeParameter));
            return this;
        }

        public TypeData<T> build() {
            return new TypeData<T>(this.type, Collections.unmodifiableList(this.typeParameters));
        }

        public String toString() {
            Object value = this.type.getSimpleName();
            if (!this.typeParameters.isEmpty()) {
                StringJoiner joiner = new StringJoiner(", ", "<", ">");
                this.typeParameters.forEach(t -> joiner.add(t.toString()));
                value = (String)value + joiner;
            }
            return value;
        }
    }

    static class TypeParameters
    implements Iterable<Type> {
        final List<Param> params = new ArrayList<Param>();

        TypeParameters() {
        }

        public static TypeParameters of(Type type) {
            if (type instanceof Class) {
                Class klass = (Class)type;
                TypeVariable<Class<T>>[] parameters = ((Class)type).getTypeParameters();
                TypeParameters params = new TypeParameters();
                for (TypeVariable parameter : parameters) {
                    params.add(new Param(parameter.getName(), (Type)((Object)Object.class)));
                }
                Type superclass = klass.getGenericSuperclass();
                if (!klass.isEnum() && superclass instanceof ParameterizedType) {
                    return TypeParameters.of((ParameterizedType)superclass, params);
                }
                return params;
            }
            throw new UnsupportedOperationException("Unsupported type passed: " + type);
        }

        public static TypeParameters of(ParameterizedType type) {
            return TypeParameters.of(type, new TypeParameters());
        }

        private static TypeParameters of(ParameterizedType type, TypeParameters subtypeParams) {
            TypeParameters params = new TypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = ((Class)type.getRawType()).getTypeParameters();
            int index = 0;
            for (int i = 0; i < typeParameters.length; ++i) {
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof TypeVariable && index < subtypeParams.params.size()) {
                    typeArgument = subtypeParams.params.get((int)index++).type;
                }
                params.add(new Param(typeParameters[i].getName(), typeArgument));
            }
            Type genericSuperclass = ((Class)type.getRawType()).getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType) {
                params = TypeParameters.of((ParameterizedType)genericSuperclass, params);
            }
            return params;
        }

        @Override
        public void forEach(Consumer<? super Type> action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<Type> spliterator() {
            return Iterable.super.spliterator();
        }

        @Override
        public Iterator<Type> iterator() {
            return this.params.stream().map(p -> p.type).iterator();
        }

        private void add(Param param) {
            this.params.add(param);
        }

        public String toString() {
            return String.format("TypeParameters{%s}", this.params);
        }

        private static class Param {
            private String name;
            private Type type;

            public Param(String name, Type type) {
                this.name = name;
                this.type = type;
            }

            public String toString() {
                return String.format("Param{name='%s', type=%s}", this.name, this.type.getTypeName());
            }
        }
    }
}

