/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.reader;

import dev.morphia.mapping.codec.reader.ArrayEndState;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.reader.ReaderState;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonType;

class ArrayState
extends ReaderState {
    public static final String NAME = "ARRAY";
    private final List<?> values;
    private ArrayEndState endState;

    ArrayState(DocumentReader reader, List<?> values) {
        super(reader);
        this.values = values;
    }

    @Override
    void skipValue() {
        this.reader().state(this.endState != null ? this.endState.nextState() : this.nextState());
    }

    @Override
    BsonType getCurrentBsonType() {
        return BsonType.ARRAY;
    }

    @Override
    String getStateName() {
        return NAME;
    }

    @Override
    void startArray() {
        if (this.endState == null) {
            List states = this.values.stream().map(this::valueState).collect(Collectors.toList());
            ReaderState docState = null;
            for (ReaderState state : states) {
                if (docState != null) {
                    docState.next(state);
                } else {
                    this.next(state);
                }
                docState = state;
            }
            this.endState = new ArrayEndState(this.reader());
            if (docState != null) {
                docState.next(this.endState);
            } else {
                this.next(this.endState);
            }
        }
        this.advance();
    }
}

