/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.reader;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.codec.BsonTypeMap;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.reader.DocumentState;
import dev.morphia.mapping.codec.reader.Mark;
import dev.morphia.mapping.codec.reader.ReaderState;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonRegularExpression;
import org.bson.BsonSerializationException;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@MorphiaInternal
public class DocumentReader
implements BsonReader {
    private static final BsonTypeMap TYPE_MAP = new BsonTypeMap();
    private final ReaderState start;
    private ReaderState current;

    public DocumentReader(Document document) {
        this.start = this.current = new DocumentState(this, document);
    }

    public ReaderState currentState() {
        return this.current;
    }

    public BsonType getCurrentBsonType() {
        return this.stage().getCurrentBsonType();
    }

    public String getCurrentName() {
        return this.stage().name();
    }

    public BsonBinary readBinaryData() {
        Object value = this.stage().value();
        if (value instanceof UUID) {
            return new BsonBinary((UUID)value);
        }
        if (value instanceof Binary) {
            return new BsonBinary(((Binary)value).getType(), ((Binary)value).getData());
        }
        return (BsonBinary)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte peekBinarySubType() {
        BsonReaderMark mark = this.getMark();
        try {
            Object binary = this.stage().value();
            if (binary instanceof UUID) {
                byte by = (byte)((UUID)binary).version();
                return by;
            }
            if (binary instanceof Binary) {
                byte by = ((Binary)binary).getType();
                return by;
            }
            byte by = ((BsonBinary)binary).getType();
            return by;
        }
        finally {
            mark.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peekBinarySize() {
        BsonReaderMark mark = this.getMark();
        try {
            Object value = this.stage().value();
            if (value instanceof UUID) {
                int n = 16;
                return n;
            }
            if (value instanceof Binary) {
                int n = ((Binary)value).getData().length;
                return n;
            }
            int n = ((BsonBinary)value).getData().length;
            return n;
        }
        finally {
            mark.reset();
        }
    }

    public BsonBinary readBinaryData(String name) {
        this.verifyName(name);
        return this.readBinaryData();
    }

    public boolean readBoolean() {
        return (Boolean)this.stage().value();
    }

    public boolean readBoolean(String name) {
        this.verifyName(name);
        return this.readBoolean();
    }

    public BsonType readBsonType() {
        return this.stage().getCurrentBsonType();
    }

    public long readDateTime() {
        Long value = Conversions.convert(this.stage().value(), Long.TYPE);
        if (value != null) {
            return value;
        }
        throw new IllegalStateException(Sofia.valueCannotBeNull(new Locale[0]));
    }

    public long readDateTime(String name) {
        this.verifyName(name);
        return this.readDateTime();
    }

    public double readDouble() {
        return (Double)this.stage().value();
    }

    public double readDouble(String name) {
        this.verifyName(name);
        return this.readDouble();
    }

    public void readEndArray() {
        this.stage().endArray();
    }

    public void readEndDocument() {
        this.stage().endDocument();
    }

    public int readInt32() {
        return (Integer)this.stage().value();
    }

    public int readInt32(String name) {
        this.verifyName(name);
        return this.readInt32();
    }

    public long readInt64() {
        return (Long)this.stage().value();
    }

    public long readInt64(String name) {
        this.verifyName(name);
        return this.readInt64();
    }

    public Decimal128 readDecimal128() {
        return (Decimal128)this.stage().value();
    }

    public Decimal128 readDecimal128(String name) {
        this.verifyName(name);
        return this.readDecimal128();
    }

    public String readJavaScript() {
        return ((BsonJavaScript)this.stage().value()).getCode();
    }

    public String readJavaScript(String name) {
        this.verifyName(name);
        return this.readJavaScript();
    }

    public String readJavaScriptWithScope() {
        return ((BsonJavaScriptWithScope)this.stage().value()).getCode();
    }

    public String readJavaScriptWithScope(String name) {
        this.verifyName(name);
        return this.readJavaScriptWithScope();
    }

    public void readMaxKey() {
    }

    public void readMaxKey(String name) {
        this.verifyName(name);
        this.readMaxKey();
    }

    public void readMinKey() {
    }

    public void readMinKey(String name) {
        this.verifyName(name);
        this.readMinKey();
    }

    public String readName() {
        return this.stage().name();
    }

    public void readName(String name) {
        this.verifyName(name);
    }

    public void readNull() {
        this.stage().advance();
    }

    public void readNull(String name) {
        this.verifyName(name);
        this.readNull();
    }

    public ObjectId readObjectId() {
        return (ObjectId)this.stage().value();
    }

    public ObjectId readObjectId(String name) {
        this.verifyName(name);
        return this.readObjectId();
    }

    public BsonRegularExpression readRegularExpression() {
        return (BsonRegularExpression)this.stage().value();
    }

    public BsonRegularExpression readRegularExpression(String name) {
        this.verifyName(name);
        return this.readRegularExpression();
    }

    public BsonDbPointer readDBPointer() {
        return (BsonDbPointer)this.stage().value();
    }

    public BsonDbPointer readDBPointer(String name) {
        this.verifyName(name);
        return this.readDBPointer();
    }

    public void readStartArray() {
        this.stage().startArray();
    }

    public void readStartDocument() {
        this.stage().startDocument();
    }

    public String readString() {
        return (String)this.stage().value();
    }

    public String readString(String name) {
        this.verifyName(name);
        return this.readString();
    }

    public String readSymbol() {
        return (String)this.stage().value();
    }

    public String readSymbol(String name) {
        this.verifyName(name);
        return this.readSymbol();
    }

    public BsonTimestamp readTimestamp() {
        return (BsonTimestamp)this.stage().value();
    }

    public BsonTimestamp readTimestamp(String name) {
        this.verifyName(name);
        return this.readTimestamp();
    }

    public void readUndefined() {
    }

    public void readUndefined(String name) {
        this.verifyName(name);
        this.readUndefined();
    }

    public void skipName() {
        this.stage().skipName();
    }

    public void skipValue() {
        this.stage().skipValue();
    }

    public BsonReaderMark getMark() {
        return new Mark(this, this.stage());
    }

    public void close() {
    }

    protected void verifyName(String expectedName) {
        String actualName = this.readName();
        if (!actualName.equals(expectedName)) {
            throw new BsonSerializationException(String.format("Expected element name to be '%s', not '%s'.", expectedName, actualName));
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", DocumentReader.class.getSimpleName() + "[", "]");
        for (ReaderState location = this.start; location != null; location = location.nextState()) {
            if (location == this.current) {
                joiner.add("<<" + location + ">>");
                continue;
            }
            joiner.add(location.toString());
        }
        return joiner.toString();
    }

    BsonType getBsonType(@Nullable Object o) {
        BsonType bsonType;
        BsonType bsonType2 = bsonType = o == null ? BsonType.NULL : TYPE_MAP.get(o.getClass());
        if (bsonType == null) {
            bsonType = o instanceof List ? BsonType.ARRAY : BsonType.UNDEFINED;
        }
        return bsonType;
    }

    void reset(ReaderState bookmark) {
        this.current = bookmark;
    }

    ReaderState stage() {
        return this.current;
    }

    void state(@Nullable ReaderState next) {
        this.current = next;
    }
}

