/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.reader;

import com.mongodb.DBRef;
import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.reader.ArrayState;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.reader.DocumentState;
import dev.morphia.mapping.codec.reader.ValueState;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonType;
import org.bson.Document;

abstract class ReaderState {
    private final DocumentReader reader;
    private ReaderState nextState;

    ReaderState(DocumentReader reader) {
        this.reader = reader;
    }

    @Nullable
    public ReaderState nextState() {
        return this.nextState;
    }

    public DocumentReader reader() {
        return this.reader;
    }

    public String toString() {
        return this.getStateName();
    }

    protected ReaderState valueState(Object value) {
        Object unwind = this.unwind(value);
        if (unwind instanceof Document) {
            return new DocumentState(this.reader, (Document)unwind);
        }
        if (unwind instanceof List) {
            return new ArrayState(this.reader, (List)unwind);
        }
        return new ValueState(this.reader, unwind);
    }

    void advance() {
        this.reader.state(this.nextState);
    }

    void endArray() {
        throw new IllegalStateException(Sofia.invalidReaderState("endArray", "ARRAY", this.getStateName(), new Locale[0]));
    }

    void endDocument() {
        throw new IllegalStateException(Sofia.invalidReaderState("endDocument", "DOCUMENT", this.getStateName(), new Locale[0]));
    }

    abstract BsonType getCurrentBsonType();

    abstract String getStateName();

    String name() {
        throw new IllegalStateException(Sofia.invalidReaderState("readName", "NAME", this.getStateName(), new Locale[0]));
    }

    void next(ReaderState next) {
        ReaderState old = this.nextState;
        this.nextState = next;
        if (this.nextState != null) {
            this.nextState.nextState = old;
        }
    }

    void skipName() {
        throw new IllegalStateException(Sofia.invalidReaderState("skipName", "NAME", this.getStateName(), new Locale[0]));
    }

    void skipValue() {
        throw new IllegalStateException(Sofia.invalidReaderState("skipValue", "VALUE", this.getStateName(), new Locale[0]));
    }

    void startArray() {
        throw new IllegalStateException(Sofia.invalidReaderState("startArray", "ARRAY", this.getStateName(), new Locale[0]));
    }

    void startDocument() {
        throw new IllegalStateException(Sofia.invalidReaderState("startDocument", "DOCUMENT", this.getStateName(), new Locale[0]));
    }

    private Object unwind(Object value) {
        Object unwind = value;
        if (value instanceof DBRef) {
            DBRef dbRef = (DBRef)value;
            Document document = new Document("$ref", (Object)dbRef.getCollectionName()).append("$id", dbRef.getId());
            if (dbRef.getDatabaseName() != null) {
                document.append("$db", (Object)dbRef.getDatabaseName());
            }
            unwind = document;
        } else if (value instanceof UUID) {
            unwind = new BsonBinary((UUID)value);
        }
        return unwind;
    }

    <T> T value() {
        throw new IllegalStateException(Sofia.invalidReaderState("read value", "VALUE", this.getStateName(), new Locale[0]));
    }
}

