/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.references;

import com.mongodb.DBRef;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.BaseReferenceCodec;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyHandler;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.references.MorphiaProxy;
import dev.morphia.mapping.codec.references.ReferenceProxy;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.experimental.ListReference;
import dev.morphia.mapping.experimental.MapReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.experimental.SetReference;
import dev.morphia.mapping.experimental.SingleReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.query.QueryException;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;

@MorphiaInternal
public class ReferenceCodec
extends BaseReferenceCodec<Object>
implements PropertyHandler {
    private final Reference annotation;
    private final BsonTypeClassMap bsonTypeClassMap = new BsonTypeClassMap();
    private final Mapper mapper;
    private static final String FIELD_INVOCATION_HANDLER = "handler";
    private final TypeCache<TypeCache.SimpleKey> typeCache = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private Datastore datastore;

    public ReferenceCodec(Datastore datastore, PropertyModel propertyModel) {
        super(datastore, propertyModel);
        this.datastore = datastore;
        this.mapper = datastore.getMapper();
        this.annotation = ReferenceCodec.getReferenceAnnotation(propertyModel);
    }

    @Nullable
    @MorphiaInternal
    public static Object encodeId(Mapper mapper, Object value, EntityModel model) {
        Class<Object> type;
        Object idValue;
        if (value instanceof Key) {
            idValue = ((Key)value).getId();
            String collectionName = ((Key)value).getCollection();
            Class<Object> clazz = type = collectionName != null ? mapper.getClassFromCollection(collectionName) : ((Key)value).getType();
            if (type == null) {
                throw new MappingException("The type for the reference could not be determined for the key " + value);
            }
        } else {
            idValue = mapper.getId(value);
            if (idValue == null) {
                return !mapper.isMappable(value.getClass()) ? value : null;
            }
            type = value.getClass();
        }
        String valueCollectionName = mapper.getEntityModel(type).getCollectionName();
        String fieldCollectionName = model.getCollectionName();
        Reference annotation = model.getAnnotation(Reference.class);
        if (annotation != null && !annotation.idOnly() || valueCollectionName != null && !valueCollectionName.equals(fieldCollectionName)) {
            idValue = new DBRef(valueCollectionName, idValue);
        }
        return idValue;
    }

    @NonNull
    public static Object processId(Datastore datastore, Object decode, DecoderContext decoderContext) {
        Object id = decode;
        if (id instanceof Iterable) {
            Iterable iterable = (Iterable)id;
            DBRef ids = new ArrayList();
            for (Object o : iterable) {
                ids.add(ReferenceCodec.processId(datastore, o, decoderContext));
            }
            id = ids;
        } else if (id instanceof Document) {
            Document document = (Document)id;
            if (document.containsKey((Object)"$ref")) {
                id = ReferenceCodec.processId(datastore, new DBRef(document.getString((Object)"$db"), document.getString((Object)"$ref"), document.get((Object)"$id")), decoderContext);
            } else if (document.containsKey((Object)datastore.getMapper().getConfig().discriminatorKey())) {
                try {
                    id = datastore.getCodecRegistry().get(datastore.getMapper().getClass(document)).decode((BsonReader)new DocumentReader(document), decoderContext);
                }
                catch (CodecConfigurationException e) {
                    throw new MappingException(Sofia.cannotFindTypeInDocument(new Locale[0]), e);
                }
            }
        } else if (id instanceof DBRef) {
            DBRef ref = id;
            Object refId = ref.getId();
            if (refId instanceof Document) {
                refId = datastore.getCodecRegistry().get(Object.class).decode((BsonReader)new DocumentReader((Document)refId), decoderContext);
            }
            id = new DBRef(ref.getDatabaseName(), ref.getCollectionName(), refId);
        }
        return id;
    }

    @Nullable
    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        Object decode = this.getDatastore().getCodecRegistry().get(this.bsonTypeClassMap.get(reader.getCurrentBsonType())).decode(reader, decoderContext);
        decode = ReferenceCodec.processId(this.getDatastore(), decode, decoderContext);
        return this.fetch(decode);
    }

    private static TypeCache.SimpleKey getCacheKey(Class<?> type) {
        return new TypeCache.SimpleKey(type, Arrays.asList(type.getInterfaces()));
    }

    @Override
    @Nullable
    public Object encode(Object value) {
        try {
            DocumentWriter writer = new DocumentWriter(this.mapper.getConfig());
            ExpressionHelper.document(writer, () -> {
                writer.writeName("ref");
                this.encode(writer, value, EncoderContext.builder().build());
            });
            return writer.getDocument().get((Object)"ref");
        }
        catch (ReferenceException e) {
            Reference refAnn = this.getPropertyModel().getAnnotation(Reference.class);
            if (refAnn != null && refAnn.ignoreMissing()) {
                return null;
            }
            throw e;
        }
    }

    public void encode(BsonWriter writer, Object instance, EncoderContext encoderContext) {
        Object idValue = this.collectIdValues(instance);
        if (idValue != null) {
            Codec codec = this.getDatastore().getCodecRegistry().get(idValue.getClass());
            codec.encode(writer, idValue, encoderContext);
        } else if (ReferenceCodec.getReferenceAnnotation(this.getPropertyModel()).ignoreMissing()) {
            writer.writeNull();
        } else {
            throw new ReferenceException(Sofia.noIdForReference(new Locale[0]));
        }
    }

    public Class getEncoderClass() {
        TypeData<?> type = this.getTypeData();
        List<TypeData<?>> typeParameters = type.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            type = typeParameters.get(typeParameters.size() - 1);
        }
        return type.getType();
    }

    @Nullable
    private Object collectIdValues(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(o -> this.collectIdValues(o)).collect(Collectors.toCollection(ArrayList::new));
        }
        if (value instanceof Map) {
            LinkedHashMap<String, Object> ids = new LinkedHashMap<String, Object>();
            Map map = (Map)value;
            for (Map.Entry o2 : map.entrySet()) {
                ids.put(o2.getKey().toString(), this.collectIdValues(o2.getValue()));
            }
            return ids;
        }
        if (value.getClass().isArray()) {
            return Arrays.stream((Object[])value).map(o -> this.collectIdValues(o)).collect(Collectors.toCollection(ArrayList::new));
        }
        return this.encodeId(value);
    }

    private <T> T createProxy(MorphiaReference<?> reference) {
        ReferenceProxy referenceProxy = new ReferenceProxy(reference);
        PropertyModel propertyModel = this.getPropertyModel();
        try {
            Class<?> type = propertyModel.getType();
            Class proxyClass = this.typeCache.findOrInsert(type.getClassLoader(), (Object)ReferenceCodec.getCacheKey(type), this::makeProxy, this.typeCache);
            Object proxy = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field field = proxyClass.getDeclaredField(FIELD_INVOCATION_HANDLER);
            field.setAccessible(true);
            field.set(proxy, referenceProxy);
            return proxy;
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    @Nullable
    private Object encodeId(Object value) {
        String valueCollectionName;
        Object idValue;
        if (value instanceof Key) {
            idValue = ((Key)value).getId();
            String collectionName = ((Key)value).getCollection();
            Class type = ((Key)value).getType();
            if (collectionName == null || type == null) {
                throw new QueryException("Missing type or collection information in key");
            }
            valueCollectionName = collectionName;
        } else {
            idValue = this.mapper.getId(value);
            if (idValue == null && !this.annotation.ignoreMissing()) {
                if (!this.mapper.isMappable(value.getClass())) {
                    return value;
                }
                throw new QueryException("No ID value found on referenced entity.  Save referenced entities before defining references to them.");
            }
            valueCollectionName = this.mapper.getEntityModel(value.getClass()).getCollectionName();
        }
        if (!this.annotation.idOnly()) {
            idValue = new DBRef(valueCollectionName, idValue);
        }
        return idValue;
    }

    private <T> Class<T> makeProxy() {
        PropertyModel propertyModel = this.getPropertyModel();
        Class<?> type = propertyModel.getType();
        DynamicType.Builder builder = new ByteBuddy().subclass(type).implement(new Type[]{MorphiaProxy.class}).name(String.format("%s$%s$$ReferenceProxy", propertyModel.getEntityModel().getName(), propertyModel.getName()));
        ElementMatcher.Junction matcher = ElementMatchers.isDeclaredBy(type);
        if (!type.isInterface()) {
            for (type = type.getSuperclass(); type != null && !type.equals(Object.class); type = type.getSuperclass()) {
                matcher = matcher.or((ElementMatcher)ElementMatchers.isDeclaredBy(type));
            }
        }
        return builder.invokable((ElementMatcher)matcher.or((ElementMatcher)ElementMatchers.isDeclaredBy(MorphiaProxy.class))).intercept((Implementation)InvocationHandlerAdapter.toField((String)FIELD_INVOCATION_HANDLER)).defineField(FIELD_INVOCATION_HANDLER, InvocationHandler.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).make().load(Thread.currentThread().getContextClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
    }

    @Nullable
    private Object fetch(Object value) {
        Class<?> type = this.getPropertyModel().getType();
        MorphiaReference<?> reference = List.class.isAssignableFrom(type) ? this.readList((List)value) : (Map.class.isAssignableFrom(type) ? this.readMap((Map)value) : (Set.class.isAssignableFrom(type) ? this.readSet((List)value) : (type.isArray() ? this.readList((List)value) : (value instanceof Document ? this.readDocument((Document)value) : this.readSingle(value)))));
        reference.ignoreMissing(this.annotation.ignoreMissing());
        return !this.annotation.lazy() ? reference.get() : this.createProxy(reference);
    }

    private List<?> mapToEntitiesIfNecessary(List<?> value) {
        Codec codec = this.getDatastore().getCodecRegistry().get(this.getEntityModelForField().getType());
        return value.stream().filter(v -> v instanceof Document && ((Document)v).containsKey((Object)"_id")).map(d -> codec.decode((BsonReader)new DocumentReader((Document)d), DecoderContext.builder().build())).collect(Collectors.toList());
    }

    MorphiaReference<?> readDocument(Document value) {
        Object id = this.getDatastore().getCodecRegistry().get(Object.class).decode((BsonReader)new DocumentReader(value), DecoderContext.builder().build());
        return this.readSingle(id);
    }

    MorphiaReference<?> readList(List<?> value) {
        List<?> mapped = this.mapToEntitiesIfNecessary(value);
        return mapped.isEmpty() ? new ListReference(this.datastore, this.getEntityModelForField(), value) : new ListReference(this.datastore, mapped);
    }

    MorphiaReference<?> readMap(Map<Object, Object> value) {
        LinkedHashMap<String, Object> ids = new LinkedHashMap<String, Object>();
        Class<?> keyType = this.getTypeData().getTypeParameters().get(0).getType();
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            ids.put((String)Conversions.convert(entry.getKey(), keyType), entry.getValue());
        }
        return new MapReference(this.datastore, ids, this.getEntityModelForField());
    }

    MorphiaReference<?> readSet(List<?> value) {
        List<?> mapped = this.mapToEntitiesIfNecessary(value);
        return mapped.isEmpty() ? new SetReference(this.datastore, this.getEntityModelForField(), value) : new SetReference(this.datastore, new LinkedHashSet(mapped));
    }

    MorphiaReference<?> readSingle(Object value) {
        return new SingleReference(this.datastore, this.getEntityModelForField(), value);
    }
}

