/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import dev.morphia.mapping.codec.writer.DocumentState;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.codec.writer.ValueState;
import dev.morphia.mapping.codec.writer.WriteState;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.bson.Document;

class ArrayState
extends ValueState<List<Object>> {
    private final List<Object> list = new ArrayList<Object>();
    private boolean finished = false;
    private ValueState<?> substate;

    ArrayState(DocumentWriter writer, WriteState previous) {
        super(writer, previous);
    }

    public List<Object> getList() {
        return this.list;
    }

    @Override
    protected String state() {
        return "array";
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", this.finished ? "]" : "");
        this.list.forEach(v -> joiner.add(v instanceof Document ? ((Document)v).toJson() : String.valueOf(v)));
        if (this.substate != null) {
            joiner.add(this.substate.toString());
        }
        return joiner.toString();
    }

    @Override
    public List<Object> value() {
        return this.list;
    }

    @Override
    void value(Object value) {
        this.list.add(value);
    }

    @Override
    WriteState array() {
        this.substate = new ArrayState(this.getWriter(), this);
        return this.substate;
    }

    @Override
    WriteState document() {
        this.substate = new DocumentState(this.getWriter(), this);
        return this.substate;
    }

    @Override
    void end() {
        this.finished = true;
        if (this.substate != null) {
            this.substate.end();
        }
        super.end();
    }

    @Override
    void done() {
        if (this.substate != null) {
            this.list.add(this.substate.value());
            this.substate = null;
        }
        super.done();
    }
}

