/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.codec.writer.NameState;
import dev.morphia.mapping.codec.writer.ValueState;
import dev.morphia.mapping.codec.writer.WriteState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.bson.Document;

class DocumentState
extends ValueState<Map<String, Object>> {
    private final List<NameState> values = new ArrayList<NameState>();
    private Document finished;

    DocumentState(DocumentWriter writer, WriteState previous) {
        super(writer, previous);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "{", this.finished != null ? "}" : "");
        this.values.forEach(v -> joiner.add(String.valueOf(v)));
        return joiner.toString();
    }

    @Override
    public Map<String, Object> value() {
        return this.finished;
    }

    @Override
    protected String state() {
        return "document";
    }

    private Document andTogether(Document doc, String key, @Nullable Object additional) {
        if (additional != null) {
            Document newSubdoc = new Document(key, additional);
            Object extant = doc.remove((Object)key);
            ArrayList<Document> and = (ArrayList<Document>)doc.get((Object)"$and");
            if (and != null) {
                and.add(newSubdoc);
            } else {
                and = new ArrayList<Document>();
                and.addAll(List.of(new Document(key, extant), newSubdoc));
                doc.put("$and", and);
                return newSubdoc;
            }
        }
        return doc;
    }

    @Override
    void end() {
        this.finished = new Document();
        this.values.forEach(v -> {
            Object doc = this.finished.get((Object)v.name());
            if (doc == null) {
                this.finished.put(v.name(), v.value());
            } else {
                this.andTogether(this.finished, v.name(), v.value());
            }
        });
        super.end();
    }

    @Override
    NameState name(String name) {
        NameState state = new NameState(this.getWriter(), name, this);
        this.values.add(state);
        return state;
    }
}

