/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.writer.RootState;
import dev.morphia.mapping.codec.writer.WriteState;
import java.time.Instant;
import java.time.LocalDateTime;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@MorphiaInternal
public class DocumentWriter
implements BsonWriter {
    private final RootState root;
    private final MorphiaConfig config;
    private WriteState state;

    public DocumentWriter(MorphiaConfig config) {
        this.config = config;
        this.root = new RootState(this);
        this.state = this.root;
    }

    public DocumentWriter(MorphiaConfig config, Document seed) {
        this.root = new RootState(this, seed);
        this.config = config;
        this.state = this.root;
    }

    public DocumentWriter encode(CodecRegistry codecRegistry, Object value, EncoderContext encoderContext) {
        codecRegistry.get(value.getClass()).encode((BsonWriter)this, value, encoderContext);
        return this;
    }

    public static Document encode(Object value, Mapper mapper, CodecRegistry codecRegistry) {
        return DocumentWriter.encode(value, mapper, codecRegistry, EncoderContext.builder().build());
    }

    public static Document encode(Object value, Mapper mapper, CodecRegistry codecRegistry, EncoderContext encoderContext) {
        DocumentWriter writer = new DocumentWriter(mapper.getConfig());
        Codec codec = codecRegistry.get(value.getClass());
        codec.encode((BsonWriter)writer, value, encoderContext);
        return writer.getDocument();
    }

    public void flush() {
    }

    public Document getDocument() {
        return this.root.getDocument();
    }

    public WriteState state() {
        return this.state;
    }

    public void writeBinaryData(BsonBinary binary) {
        this.state.value(binary);
    }

    public void writeBinaryData(String name, BsonBinary binary) {
        this.state.name(name).value(binary);
    }

    public void writeBoolean(boolean value) {
        this.state.value(value);
    }

    public void writeBoolean(String name, boolean value) {
        this.state.name(name).value(value);
    }

    public void writeDateTime(long value) {
        this.state.value(LocalDateTime.ofInstant(Instant.ofEpochMilli(value), this.config.dateStorage().getZone()));
    }

    public void writeDateTime(String name, long value) {
        this.state.name(name);
        this.writeDateTime(value);
    }

    public void writeDBPointer(BsonDbPointer value) {
        this.state.value(value);
    }

    public void writeDBPointer(String name, BsonDbPointer value) {
        this.state.name(name).value(value);
    }

    public void writeDouble(double value) {
        this.state.value(value);
    }

    public void writeDouble(String name, double value) {
        this.state.name(name).value(value);
    }

    public void writeEndArray() {
        this.state.end();
    }

    public void writeEndDocument() {
        this.state.end();
    }

    public void writeInt32(int value) {
        this.state.value(value);
    }

    public void writeInt32(String name, int value) {
        this.state.name(name).value(value);
    }

    public void writeInt64(long value) {
        this.state.value(value);
    }

    public void writeInt64(String name, long value) {
        this.state.name(name).value(value);
    }

    public void writeDecimal128(Decimal128 value) {
        this.state.value(value);
    }

    public void writeDecimal128(String name, Decimal128 value) {
        this.state.name(name).value(value);
    }

    public void writeJavaScript(String code) {
        this.state.value(code);
    }

    public void writeMaxKey(String name) {
        this.writeName(name);
        this.writeMaxKey();
    }

    public void writeJavaScript(String name, String code) {
        this.state.name(name).value(code);
    }

    public void writeMinKey(String name) {
        this.writeName(name);
        this.writeMinKey();
    }

    public void writeJavaScriptWithScope(String code) {
        this.state.value(code);
    }

    public void writeJavaScriptWithScope(String name, String code) {
        this.state.name(name).value(code);
    }

    public void writeMaxKey() {
        this.state.value(new BsonMaxKey());
    }

    public void writeMinKey() {
        this.state.value(new BsonMinKey());
    }

    public void writeName(String name) {
        this.state.name(name);
    }

    public void writeNull() {
        this.state.value(null);
    }

    public void writeNull(String name) {
        this.writeName(name);
        this.state.value(null);
    }

    public void writeObjectId(ObjectId objectId) {
        this.state.value(objectId);
    }

    public void writeStartArray(String name) {
        this.writeName(name);
        this.writeStartArray();
    }

    public void writeObjectId(String name, ObjectId objectId) {
        this.state.name(name).value(objectId);
    }

    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.state.value(regularExpression);
    }

    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.state.name(name).value(regularExpression);
    }

    public void writeStartArray() {
        this.state.array();
    }

    public void writeStartDocument() {
        this.state.document();
    }

    public void writeSymbol(String name, String value) {
        this.writeName(name);
        this.writeSymbol(value);
    }

    public void writeStartDocument(String name) {
        this.state.name(name).document();
    }

    public void writeString(String value) {
        this.state.value(value);
    }

    public void writeString(String name, String value) {
        this.state.name(name).value(value);
    }

    public void writeUndefined(String name) {
        this.writeName(name);
        this.writeUndefined();
    }

    public void pipe(BsonReader reader) {
        throw new UnsupportedOperationException("org.bson.io.TestingDocumentWriter.pipe has not yet been implemented.");
    }

    public void writeSymbol(String value) {
        this.state.value(new BsonSymbol(value));
    }

    public void writeTimestamp(BsonTimestamp value) {
        this.state.value(value);
    }

    public void writeTimestamp(String name, BsonTimestamp value) {
        this.writeName(name);
        this.state.value(value);
    }

    public void writeUndefined() {
        this.state.value(new BsonUndefined());
    }

    public String toString() {
        return this.root.toString();
    }

    void state(WriteState state) {
        this.state = state;
    }
}

