/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.writer.ArrayState;
import dev.morphia.mapping.codec.writer.DocumentState;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.codec.writer.PendingValue;
import dev.morphia.mapping.codec.writer.SingleValue;
import dev.morphia.mapping.codec.writer.ValueState;
import dev.morphia.mapping.codec.writer.WriteState;

class NameState
extends WriteState {
    private final String name;
    private ValueState value = PendingValue.SLUG;

    NameState(DocumentWriter writer, String name, WriteState previous) {
        super(writer, previous);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }

    @Nullable
    public Object value() {
        return this.value.value();
    }

    @Override
    protected String state() {
        return "name";
    }

    @Override
    WriteState array() {
        this.value = new ArrayState(this.getWriter(), this);
        return this.value;
    }

    @Override
    WriteState document() {
        this.value = new DocumentState(this.getWriter(), this);
        return this.value;
    }

    @Override
    void done() {
        this.end();
    }

    @Override
    void value(Object value) {
        this.value = new SingleValue(this.getWriter(), value, this);
        this.value.end();
    }
}

