/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import dev.morphia.annotations.AlsoLoad;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.IdField;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Version;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.MorphiaPropertySerialization;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.MorphiaConvention;
import java.beans.Transient;
import java.lang.reflect.Modifier;
import java.util.Iterator;

@MorphiaInternal
public class ConfigureProperties
implements MorphiaConvention {
    private static boolean isTransient(PropertyModelBuilder property) {
        return property.hasAnnotation(dev.morphia.annotations.Transient.class) || property.hasAnnotation(Transient.class) || Modifier.isTransient(property.modifiers());
    }

    @Override
    public void apply(Mapper mapper, EntityModelBuilder modelBuilder) {
        IdField idProperty;
        this.processProperties(modelBuilder, mapper.getConfig());
        if (modelBuilder.idPropertyName() == null && (idProperty = modelBuilder.getAnnotation(IdField.class)) != null) {
            modelBuilder.idPropertyName(idProperty.value());
            PropertyModelBuilder propertyModelBuilder = modelBuilder.propertyModelByName(idProperty.value());
            propertyModelBuilder.mappedName("_id");
        }
    }

    private void buildProperty(MorphiaConfig config, PropertyModelBuilder builder) {
        builder.serialization(new MorphiaPropertySerialization(config, builder));
        if (this.isNotConcrete(builder.typeData())) {
            builder.discriminatorEnabled(true);
        }
    }

    void processProperties(EntityModelBuilder modelBuilder, MorphiaConfig config) {
        Iterator<PropertyModelBuilder> iterator = modelBuilder.propertyModels().iterator();
        while (iterator.hasNext()) {
            AlsoLoad alsoLoad;
            PropertyModelBuilder builder = iterator.next();
            int modifiers = builder.modifiers();
            if (Modifier.isStatic(modifiers) || ConfigureProperties.isTransient(builder)) {
                iterator.remove();
                continue;
            }
            Property property = builder.getAnnotation(Property.class);
            if (property != null && !property.concreteClass().equals(Object.class)) {
                TypeData<?> typeData = builder.typeData().withType(property.concreteClass());
                builder.typeData(typeData);
            }
            if ((alsoLoad = builder.getAnnotation(AlsoLoad.class)) != null) {
                for (String name : alsoLoad.value()) {
                    builder.alternateName(name);
                }
            }
            if (builder.getAnnotation(Id.class) != null) {
                modelBuilder.idPropertyName(builder.name());
            }
            if (builder.getAnnotation(Version.class) != null) {
                modelBuilder.versionPropertyName(builder.name());
            }
            this.buildProperty(config, builder);
        }
    }

    private boolean isNotConcrete(TypeData<?> typeData) {
        Class<?> type = !typeData.getTypeParameters().isEmpty() ? typeData.getTypeParameters().get(typeData.getTypeParameters().size() - 1).getType() : typeData.getType();
        return this.isNotConcrete(type);
    }

    private boolean isNotConcrete(Class<?> type) {
        Class<?> componentType = type;
        if (type.isArray()) {
            componentType = type.getComponentType();
        }
        return componentType.isInterface() || Modifier.isAbstract(componentType.getModifiers());
    }

    String applyDefaults(String configured, String defaultValue) {
        if (!configured.equals(".")) {
            return configured;
        }
        return defaultValue;
    }
}

