/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import com.mongodb.lang.NonNull;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.MethodAccessor;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.MorphiaConvention;
import dev.morphia.sofia.Sofia;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@MorphiaInternal
public class MethodDiscovery
implements MorphiaConvention {
    private EntityModelBuilder entityModelBuilder;

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void apply(Mapper mapper, EntityModelBuilder builder) {
        if (builder.propertyModels().isEmpty()) {
            this.entityModelBuilder = builder;
            LinkedHashSet hierarchy = new LinkedHashSet(Set.of(builder.type()));
            hierarchy.addAll(builder.classHierarchy());
            LinkedHashSet<Methods> properties = new LinkedHashSet<Methods>();
            for (Class clazz : hierarchy) {
                properties.addAll(this.processMethods(clazz));
            }
            this.addProperties(builder, properties);
        }
    }

    private List<Methods> processMethods(Class<?> type) {
        return Arrays.stream(type.getDeclaredMethods()).filter(MethodDiscovery::isGetterSetter).filter(m -> !m.isSynthetic()).collect(Collectors.groupingBy(this::stripPrefix)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == 2).map(entry -> new Methods((String)entry.getKey(), type, (List)entry.getValue())).collect(Collectors.toList());
    }

    private void addProperties(EntityModelBuilder builder, Set<Methods> properties) {
        for (Methods methods : properties) {
            TypeData<?> typeData = this.entityModelBuilder.getTypeData(methods.type, TypeData.get(methods.getter), methods.getter.getGenericReturnType());
            this.entityModelBuilder.addProperty().name(methods.property).accessor(new MethodAccessor(this.getTargetMethod(builder, methods.getter), this.getTargetMethod(builder, methods.setter))).annotations(this.discoverAnnotations(methods.getter, methods.setter)).typeData(typeData).discoverMappedName();
        }
    }

    @NonNull
    private String stripPrefix(Method m) {
        return m.getName().startsWith("get") || m.getName().startsWith("set") ? this.stripPrefix(m, 3) : this.stripPrefix(m, 2);
    }

    private static boolean isGetterSetter(Method m) {
        return m.getName().startsWith("get") || m.getName().startsWith("set") || m.getName().startsWith("is");
    }

    private List<Annotation> discoverAnnotations(Method getter, Method setter) {
        return Stream.of(getter, setter).flatMap(m -> Arrays.stream(m.getDeclaredAnnotations())).collect(Collectors.toList());
    }

    @NonNull
    private Method getTargetMethod(EntityModelBuilder builder, @NonNull Method method) {
        try {
            if (builder.type().equals(builder.targetType())) {
                return method;
            }
            return builder.targetType().getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (ReflectiveOperationException e) {
            throw new MappingException(Sofia.mismatchedMethodOnExternalType(method.getName(), method.getParameterTypes(), builder.type().getName(), builder.targetType().getName(), new Locale[0]));
        }
    }

    private String stripPrefix(Method method, int size) {
        Object name = method.getName().substring(size);
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        return name;
    }

    private static class Methods {
        private final Method getter;
        private final Method setter;
        private final String property;
        private final Class<?> type;

        Methods(String property, Class<?> type, List<Method> methods) {
            this.property = property;
            this.type = type;
            List collect = methods.stream().sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
            this.getter = (Method)collect.get(0);
            this.setter = (Method)collect.get(1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Methods)) {
                return false;
            }
            Methods methods = (Methods)o;
            return this.property.equals(methods.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }
    }
}

