/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.ExternalEntity;
import dev.morphia.annotations.internal.EntityBuilder;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.config.MorphiaConfig;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.conventions.MorphiaConvention;

@MorphiaInternal
public class MorphiaDefaultsConvention
implements MorphiaConvention {
    @Override
    public void apply(Mapper mapper, EntityModelBuilder modelBuilder) {
        MorphiaConfig config = mapper.getConfig();
        Entity entity = modelBuilder.getAnnotation(Entity.class);
        Embedded embedded = modelBuilder.getAnnotation(Embedded.class);
        ExternalEntity externalEntity = modelBuilder.getAnnotation(ExternalEntity.class);
        if (entity != null) {
            modelBuilder.enableDiscriminator(entity.useDiscriminator());
            modelBuilder.discriminatorKey(this.applyDefaults(entity.discriminatorKey(), config.discriminatorKey()));
        } else if (externalEntity != null) {
            modelBuilder.enableDiscriminator(externalEntity.useDiscriminator());
            modelBuilder.discriminatorKey(this.applyDefaults(externalEntity.discriminatorKey(), config.discriminatorKey()));
            modelBuilder.annotation(EntityBuilder.entityBuilder().cap(externalEntity.cap()).concern(externalEntity.concern()).discriminator(externalEntity.discriminator()).discriminatorKey(externalEntity.discriminatorKey()).value(externalEntity.value()).useDiscriminator(externalEntity.useDiscriminator()).build());
            modelBuilder.targetType(externalEntity.target());
        } else {
            modelBuilder.enableDiscriminator(embedded == null || embedded.useDiscriminator());
            modelBuilder.discriminatorKey(this.applyDefaults(embedded != null ? embedded.discriminatorKey() : ".", config.discriminatorKey()));
        }
        config.discriminator().apply(modelBuilder);
    }

    String applyDefaults(String configured, String defaultValue) {
        if (!configured.equals(".")) {
            return configured;
        }
        return defaultValue;
    }
}

