/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBRef;
import dev.morphia.Datastore;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.references.ReferenceCodec;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@MorphiaInternal
@Deprecated(forRemoval=true, since="2.3")
public abstract class CollectionReference<C extends Collection>
extends MorphiaReference<C> {
    private final Map<String, List<Object>> collections = new HashMap<String, List<Object>>();
    private EntityModel entityModel;
    private List ids;

    protected CollectionReference(Datastore datastore, EntityModel entityModel, List ids) {
        super(datastore);
        this.entityModel = entityModel;
        if (ids != null) {
            if (ids.stream().allMatch(entityModel.getType()::isInstance)) {
                this.setValues(ids);
            } else {
                for (Object o : ids) {
                    CollectionReference.collate(entityModel, this.collections, o);
                }
                this.ids = ids;
            }
        }
    }

    static void collate(EntityModel valueType, Map<String, List<Object>> collections, Object o) {
        Object id;
        String collectionName;
        if (o instanceof DBRef) {
            DBRef dbRef = (DBRef)o;
            collectionName = dbRef.getCollectionName();
            id = dbRef.getId();
        } else {
            collectionName = valueType.getCollectionName();
            id = o;
        }
        CollectionReference.register(collections, collectionName).add(id);
    }

    static List register(Map<String, List<Object>> collections, String name) {
        return collections.computeIfAbsent(name, k -> new ArrayList());
    }

    protected CollectionReference(Datastore datastore) {
        super(datastore);
    }

    @Override
    public abstract C get();

    @Override
    public List<Object> getIds() {
        ArrayList<Object> ids = new ArrayList<Object>(this.ids);
        if (!ids.isEmpty() && ids.get(0) instanceof DBRef) {
            ListIterator<Object> iterator = ids.listIterator();
            while (iterator.hasNext()) {
                iterator.set(((DBRef)iterator.next()).getId());
            }
        }
        return ids;
    }

    @Override
    public Class<C> getType() {
        return this.entityModel.getType();
    }

    @Override
    final List<Object> getId(Mapper mapper, EntityModel entityModel) {
        if (this.ids == null) {
            this.ids = this.getValues().stream().map(v -> ReferenceCodec.encodeId(mapper, v, entityModel)).collect(Collectors.toList());
        }
        return this.ids;
    }

    abstract Collection<?> getValues();

    abstract void setValues(List var1);

    private List<Object> extractIds(List<Object> list) {
        ArrayList<Object> ids = new ArrayList<Object>();
        list.forEach(i -> {
            if (i instanceof List) {
                ids.addAll(this.extractIds((List)i));
            } else {
                ids.add(i);
            }
        });
        return ids;
    }

    private List<Object> mapIds(List list, Map<Object, Object> idMap) {
        ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(new Object[list.size()]));
        for (int i = 0; i < list.size(); ++i) {
            Object id = list.get(i);
            Object value = id instanceof List ? this.mapIds((List)id, idMap) : idMap.get(id instanceof DBRef ? ((DBRef)id).getId() : id);
            if (value == null) continue;
            values.set(i, value);
        }
        return values;
    }

    final List find() {
        HashMap<Object, Object> idMap = new HashMap<Object, Object>();
        for (Map.Entry<String, List<Object>> entry : this.collections.entrySet()) {
            idMap.putAll(this.query(entry.getKey(), this.extractIds(entry.getValue())));
        }
        List values = this.mapIds(this.ids, idMap).stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.resolve();
        return values;
    }

    Map<Object, Object> query(String collection, List<Object> collectionIds) {
        HashMap<Object, Object> idMap = new HashMap<Object, Object>();
        try (MorphiaCursor cursor = this.getDatastore().find(collection).disableValidation().filter(Filters.in("_id", collectionIds)).iterator();){
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                idMap.put(this.getMapper().getId(entity), entity);
            }
            if (!this.ignoreMissing() && idMap.size() != new HashSet<Object>(collectionIds).size()) {
                throw new ReferenceException(Sofia.missingReferencedEntities(this.entityModel.getType().getSimpleName(), new Locale[0]));
            }
        }
        return idMap;
    }
}

