/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.BaseReferenceCodec;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyHandler;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.codec.references.ReferenceCodec;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.experimental.ListReference;
import dev.morphia.mapping.experimental.MapReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.experimental.SetReference;
import dev.morphia.mapping.experimental.SingleReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.sofia.Sofia;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

@Deprecated(forRemoval=true, since="2.3")
public class MorphiaReferenceCodec
extends BaseReferenceCodec<MorphiaReference>
implements PropertyHandler {
    private final BsonTypeClassMap bsonTypeClassMap = new BsonTypeClassMap();
    private Mapper mapper;

    public MorphiaReferenceCodec(Datastore datastore, PropertyModel propertyModel) {
        super(datastore, propertyModel);
        this.mapper = datastore.getMapper();
    }

    public MorphiaReference decode(BsonReader reader, DecoderContext decoderContext) {
        Object value = this.getDatastore().getCodecRegistry().get(this.bsonTypeClassMap.get(reader.getCurrentBsonType())).decode(reader, decoderContext);
        value = ReferenceCodec.processId(this.getDatastore(), value, decoderContext);
        TypeData<?> typeData = this.getTypeData().getTypeParameters().get(0);
        EntityModel fieldEntityModel = this.getEntityModelForField();
        if (Set.class.isAssignableFrom(typeData.getType())) {
            return new SetReference(this.getDatastore(), fieldEntityModel, (List)value);
        }
        if (Collection.class.isAssignableFrom(typeData.getType())) {
            return new ListReference(this.getDatastore(), fieldEntityModel, (List)value);
        }
        if (Map.class.isAssignableFrom(typeData.getType())) {
            return new MapReference(this.getDatastore(), (Map)value, fieldEntityModel);
        }
        return new SingleReference(this.getDatastore(), fieldEntityModel, value);
    }

    @Override
    public Object encode(@Nullable Object value) {
        if (value != null) {
            MorphiaReference<Object> wrap = value instanceof MorphiaReference ? (MorphiaReference<Object>)value : MorphiaReference.wrap(this.getDatastore(), value);
            DocumentWriter writer = new DocumentWriter(this.mapper.getConfig());
            ExpressionHelper.document(writer, () -> {
                writer.writeName("ref");
                this.encode((BsonWriter)writer, wrap, EncoderContext.builder().build());
            });
            return writer.getDocument().get((Object)"ref");
        }
        throw new NullPointerException();
    }

    public void encode(BsonWriter writer, MorphiaReference value, EncoderContext encoderContext) {
        Object ids = value.getId(this.mapper, this.getEntityModelForField());
        if (ids == null || ids instanceof Collection && ((Collection)ids).isEmpty() || ids instanceof Map && ((Map)ids).isEmpty()) {
            throw new ReferenceException(Sofia.noIdForReference(new Locale[0]));
        }
        Codec codec = this.getDatastore().getCodecRegistry().get(ids.getClass());
        codec.encode(writer, ids, encoderContext);
    }

    public Class getEncoderClass() {
        return MorphiaReference.class;
    }
}

