/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.internal;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.Name;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.sofia.Sofia;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;

@MorphiaInternal
public class ConstructorCreator
implements MorphiaInstanceCreator {
    private final Object[] parameters;
    private final Constructor<?> constructor;
    private final EntityModel model;
    private final Map<String, BiFunction<Object[], Object, Void>> positions = new LinkedHashMap<String, BiFunction<Object[], Object, Void>>();
    private final List<Consumer<Object>> setFunctions = new ArrayList<Consumer<Object>>();
    private Object instance;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConstructorCreator(EntityModel model, Constructor<?> constructor) {
        this.model = model;
        this.constructor = constructor;
        this.constructor.setAccessible(true);
        Parameter[] constructorParameters = this.constructor.getParameters();
        this.parameters = new Object[constructorParameters.length];
        int i = 0;
        while (i < constructorParameters.length) {
            Parameter parameter = constructorParameters[i];
            this.parameters[i] = this.zeroValue(parameter);
            int finalI = i++;
            String name = ConstructorCreator.getParameterName(parameter);
            if (name.matches("arg[0-9]+")) {
                throw new MappingException(Sofia.unnamedConstructorParameter(model.getType().getName(), new Locale[0]));
            }
            BiFunction<Object[], Object, Void> old = this.positions.put(name, (params, v) -> {
                params[finalI] = Conversions.convert(v, parameter.getType());
                return null;
            });
            if (old == null) continue;
            throw new MappingException(Sofia.duplicatedParameterName(model.getType().getName(), name, new Locale[0]));
        }
    }

    @Nullable
    public static Constructor<?> bestConstructor(EntityModel model) {
        TreeMap propertyMap = new TreeMap();
        model.getProperties().forEach(it -> propertyMap.put(it.getName(), it.getType()));
        List<Constructor<?>> constructors = Arrays.asList(model.getType().getDeclaredConstructors());
        if (ConstructorCreator.hasLifecycleEvents(model)) {
            return constructors.stream().filter(it -> it.getParameters().length == 0).findFirst().orElseThrow(() -> new IllegalStateException(Sofia.lifecycleNoargs(model.getType(), new Locale[0])));
        }
        return constructors.stream().filter(it -> Arrays.stream(it.getParameters()).allMatch(param -> Objects.equals(propertyMap.get(ConstructorCreator.getParameterName(param)), param.getType()))).sorted((o1, o2) -> Integer.compare(o2.getParameterCount(), o1.getParameterCount())).findFirst().orElse(null);
    }

    private static boolean hasLifecycleEvents(EntityModel model) {
        return model.hasLifecycle(PreLoad.class) || model.hasLifecycle(PostLoad.class) || model.hasLifecycle(PrePersist.class) || model.hasLifecycle(PostPersist.class);
    }

    @Override
    public Object getInstance() {
        if (this.instance == null) {
            try {
                this.instance = this.constructor.newInstance(this.parameters);
                this.setFunctions.forEach(function -> function.accept(this.instance));
            }
            catch (Exception e) {
                throw new MappingException(Sofia.cannotInstantiate(this.model.getType().getName(), e.getMessage(), new Locale[0]), e);
            }
        }
        return this.instance;
    }

    @MorphiaInternal
    public static Constructor<?> getFullConstructor(EntityModel model) {
        for (Constructor<?> constructor : model.getType().getDeclaredConstructors()) {
            if (constructor.getParameterCount() != model.getProperties().size() || !ConstructorCreator.namesMatchProperties(model, constructor)) continue;
            return constructor;
        }
        throw new MappingException(Sofia.noSuitableConstructor(model.getType().getName(), new Locale[0]));
    }

    @MorphiaInternal
    public static String getParameterName(Parameter parameter) {
        Name name = parameter.getAnnotation(Name.class);
        return name != null ? name.value() : parameter.getName();
    }

    private static boolean namesMatchProperties(EntityModel model, Constructor<?> constructor) {
        for (Parameter parameter : constructor.getParameters()) {
            if (model.getProperty(ConstructorCreator.getParameterName(parameter)) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void set(@Nullable Object value, PropertyModel model) {
        if (this.instance != null) {
            model.setValue(this.instance, value);
        } else {
            BiFunction<Object[], Object, Void> function = this.positions.get(model.getName());
            if (function != null) {
                function.apply(this.parameters, value);
            }
            this.setFunctions.add(instance -> model.setValue(instance, value));
        }
    }

    @Nullable
    private Object zeroValue(Parameter parameter) {
        if (!parameter.getType().isPrimitive()) {
            return null;
        }
        if (parameter.getType().equals(Boolean.TYPE)) {
            return false;
        }
        return 0;
    }
}

