/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.lifecycle;

import com.mongodb.lang.NonNull;
import dev.morphia.Datastore;
import dev.morphia.EntityListener;
import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PostPersist;
import dev.morphia.annotations.PreLoad;
import dev.morphia.annotations.PrePersist;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.sofia.Sofia;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bson.Document;

@MorphiaInternal
public class EntityListenerAdapter
implements EntityListener<Object> {
    private final Map<Class<? extends Annotation>, List<Method>> methods;
    private final Class<?> listenerType;
    private Object listener;

    public EntityListenerAdapter(Class<?> listenerType) {
        this.methods = this.mapAnnotationsToMethods(listenerType);
        this.listenerType = listenerType;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.methods.containsKey(type);
    }

    Map<Class<? extends Annotation>, List<Method>> getMethods() {
        return this.methods;
    }

    protected Object[] collectArgs(Method method, Object entity, Document document, Datastore datastore) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (parameterType.equals(Document.class)) {
                args.add(document);
                continue;
            }
            if (parameterType.equals(Datastore.class)) {
                args.add(datastore);
                continue;
            }
            args.add(entity);
        }
        return args.toArray();
    }

    void invoke(Class<?> annotation, Object entity, Document document, Datastore datastore) {
        this.methods.get(annotation).forEach(method -> {
            try {
                method.invoke(this.getListener(), entity, document, datastore);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    Object getListener() {
        if (this.listener == null) {
            try {
                Constructor<?> constructor = this.listenerType.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.listener = constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new MappingException(Sofia.noargConstructorNotFound(this.listenerType, new Locale[0]), e);
            }
        }
        return this.listener;
    }

    @Override
    public void postLoad(@NonNull Object entity, @NonNull Document document, @NonNull Datastore datastore) {
        this.invoke(PostLoad.class, entity, document, datastore);
    }

    @Override
    public void postPersist(@NonNull Object entity, @NonNull Document document, @NonNull Datastore datastore) {
        this.invoke(PostPersist.class, entity, document, datastore);
    }

    @Override
    public void preLoad(@NonNull Object entity, @NonNull Document document, @NonNull Datastore datastore) {
        this.invoke(PreLoad.class, entity, document, datastore);
    }

    @Override
    public void prePersist(@NonNull Object entity, @NonNull Document document, @NonNull Datastore datastore) {
        this.invoke(PrePersist.class, entity, document, datastore);
    }

    @NonNull
    private Map<Class<? extends Annotation>, List<Method>> mapAnnotationsToMethods(Class<?> type) {
        HashMap<Class<? extends Annotation>, List<Method>> methods = new HashMap<Class<? extends Annotation>, List<Method>>();
        for (Method method : this.getDeclaredAndInheritedMethods(type)) {
            for (Class<? extends Annotation> annotationClass : Mapper.LIFECYCLE_ANNOTATIONS) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                method.setAccessible(true);
                methods.computeIfAbsent(annotationClass, c -> new ArrayList()).add(method);
            }
        }
        return methods;
    }

    private List<Method> getDeclaredAndInheritedMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (type == Object.class) {
            return methods;
        }
        Class<?> parent = type.getSuperclass();
        if (parent != null) {
            methods.addAll(this.getDeclaredAndInheritedMethods(parent));
        }
        for (Method m : type.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            methods.add(m);
        }
        return methods;
    }
}

