/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation;

import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.sofia.Sofia;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;

public class ConstraintViolation {
    private final EntityModel type;
    private final Class<? extends ClassConstraint> validator;
    private final String message;
    private final Level level;
    private PropertyModel property;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConstraintViolation(Level level, EntityModel entityModel, PropertyModel property, Class<? extends ClassConstraint> validator, String message) {
        this(level, entityModel, validator, message);
        this.property = property;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConstraintViolation(Level level, EntityModel entityModel, Class<? extends ClassConstraint> validator, String message) {
        this.level = level;
        this.type = entityModel;
        this.message = message;
        this.validator = validator;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getPrefix() {
        String name = this.type.getType().getName();
        String property = this.property != null ? "#" + this.property.getName() : "";
        return name + property;
    }

    public String render() {
        return Sofia.constraintViolation(this.validator.getSimpleName(), this.message, new Locale[0]);
    }

    public static enum Level {
        MINOR,
        INFO,
        WARNING,
        SEVERE,
        FATAL;

    }
}

