/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation;

import dev.morphia.annotations.Property;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.ConstraintViolationException;
import dev.morphia.mapping.validation.classrules.DuplicatedAttributeNames;
import dev.morphia.mapping.validation.classrules.EntityAndEmbed;
import dev.morphia.mapping.validation.classrules.EntityOrEmbed;
import dev.morphia.mapping.validation.classrules.MultipleId;
import dev.morphia.mapping.validation.classrules.MultipleVersions;
import dev.morphia.mapping.validation.classrules.ShardKeyNames;
import dev.morphia.mapping.validation.fieldrules.ContradictingAnnotations;
import dev.morphia.mapping.validation.fieldrules.IdDoesNotMix;
import dev.morphia.mapping.validation.fieldrules.LazyReferenceMissingDependencies;
import dev.morphia.mapping.validation.fieldrules.LazyReferenceOnArray;
import dev.morphia.mapping.validation.fieldrules.MapKeyTypeConstraint;
import dev.morphia.mapping.validation.fieldrules.ReferenceToUnidentifiable;
import dev.morphia.mapping.validation.fieldrules.VersionMisuse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MappingValidator.class);

    @MorphiaInternal
    public void validate(Mapper mapper, EntityModel entityModel) {
        TreeSet<ConstraintViolation> ve = new TreeSet<ConstraintViolation>((o1, o2) -> o1.getLevel().ordinal() > o2.getLevel().ordinal() ? -1 : 1);
        List<ClassConstraint> rules = this.getConstraints();
        for (ClassConstraint v : rules) {
            v.check(mapper, entityModel, ve);
        }
        if (!ve.isEmpty()) {
            ConstraintViolation worst = (ConstraintViolation)ve.iterator().next();
            ConstraintViolation.Level maxLevel = worst.getLevel();
            if (maxLevel.ordinal() >= ConstraintViolation.Level.FATAL.ordinal()) {
                throw new ConstraintViolationException(ve);
            }
            ArrayList<LogLine> l = new ArrayList<LogLine>();
            for (ConstraintViolation v : ve) {
                l.add(new LogLine(v));
            }
            Collections.sort(l);
            for (LogLine line : l) {
                line.log();
            }
        }
    }

    private List<ClassConstraint> getConstraints() {
        ArrayList<ClassConstraint> constraints = new ArrayList<ClassConstraint>(32);
        constraints.add(new MultipleId());
        constraints.add(new MultipleVersions());
        constraints.add(new EntityAndEmbed());
        constraints.add(new EntityOrEmbed());
        constraints.add(new DuplicatedAttributeNames());
        constraints.add(new IdDoesNotMix());
        constraints.add(new ReferenceToUnidentifiable());
        constraints.add(new LazyReferenceMissingDependencies());
        constraints.add(new LazyReferenceOnArray());
        constraints.add(new MapKeyTypeConstraint());
        constraints.add(new VersionMisuse());
        constraints.add(new ShardKeyNames());
        constraints.add(new ContradictingAnnotations(Reference.class, Property.class));
        return constraints;
    }

    static class LogLine
    implements Comparable<LogLine> {
        private final ConstraintViolation v;

        LogLine(ConstraintViolation v) {
            this.v = v;
        }

        @Override
        public int compareTo(LogLine o) {
            return this.v.getPrefix().compareTo(o.v.getPrefix());
        }

        public int hashCode() {
            return this.v.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogLine logLine = (LogLine)o;
            return this.v.equals(logLine.v);
        }

        void log() {
            switch (this.v.getLevel()) {
                case SEVERE: {
                    LOG.error(this.v.render());
                    break;
                }
                case WARNING: {
                    LOG.warn(this.v.render());
                    break;
                }
                case INFO: {
                    LOG.info(this.v.render());
                    break;
                }
                case MINOR: {
                    LOG.debug(this.v.render());
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot log %s of Level %s", new Object[]{ConstraintViolation.class.getSimpleName(), this.v.getLevel()}));
                }
            }
        }
    }
}

