/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.classrules;

import dev.morphia.annotations.ShardKey;
import dev.morphia.annotations.ShardKeys;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ShardKeyNames
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, EntityModel model, Set<ConstraintViolation> ve) {
        List<PropertyModel> shardKeys;
        ShardKeys annotation = model.getAnnotation(ShardKeys.class);
        if (annotation != null && (shardKeys = model.getShardKeys()).size() < annotation.value().length) {
            ArrayList<String> names = new ArrayList<String>();
            for (ShardKey key : annotation.value()) {
                PropertyModel property = model.getProperty(key.value());
                if (property != null) continue;
                names.add(key.value());
            }
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, model, this.getClass(), Sofia.badShardKeys(String.join((CharSequence)", ", names), new Locale[0])));
        }
    }
}

