/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.fieldrules;

import dev.morphia.annotations.Reference;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.fieldrules.PropertyConstraint;
import java.util.Set;

public class LazyReferenceOnArray
extends PropertyConstraint {
    @Override
    protected void check(Mapper mapper, EntityModel model, PropertyModel propertyModel, Set<ConstraintViolation> ve) {
        Class<?> type;
        Reference ref = propertyModel.getAnnotation(Reference.class);
        if (ref != null && ref.lazy() && (type = propertyModel.getType()).isArray()) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, model, propertyModel, this.getClass(), "The lazy attribute cannot be used for an Array. If you need a lazy array please use ArrayList instead."));
        }
    }
}

