/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.fieldrules;

import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.fieldrules.PropertyConstraint;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bson.types.ObjectId;

public class MapKeyTypeConstraint
extends PropertyConstraint {
    private static final String SUPPORTED = "(Map<String/Enum/Long/ObjectId/..., ?>)";

    @Override
    protected void check(Mapper mapper, EntityModel entityModel, PropertyModel propertyModel, Set<ConstraintViolation> ve) {
        if (propertyModel.isMap()) {
            Class<?> aClass = null;
            List<TypeData<?>> typeParameters = propertyModel.getTypeData().getTypeParameters();
            if (!typeParameters.isEmpty()) {
                TypeData<?> typeData = typeParameters.get(0);
                aClass = typeData.getType();
            }
            if (aClass == null || Object.class.equals(aClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.WARNING, entityModel, propertyModel, this.getClass(), "Maps cannot be keyed by Object (Map<Object,?>); Use a parametrized type that is supported (Map<String/Enum/Long/ObjectId/..., ?>)"));
            } else if (!(aClass.equals(String.class) || aClass.equals(ObjectId.class) || this.isPrimitiveLike(aClass))) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, entityModel, propertyModel, this.getClass(), "Maps must be keyed by a simple type (Map<String/Enum/Long/ObjectId/..., ?>); " + aClass + " is not supported as a map key type."));
            }
        }
    }

    private boolean isPrimitiveLike(Class<?> type) {
        return List.of(Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, String.class, Date.class, Locale.class, Class.class, UUID.class, URI.class).contains(type) || type.isEnum();
    }
}

