/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.fieldrules;

import dev.morphia.Key;
import dev.morphia.annotations.Reference;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.fieldrules.PropertyConstraint;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import java.util.Set;

public class ReferenceToUnidentifiable
extends PropertyConstraint {
    @Override
    protected void check(Mapper mapper, EntityModel entityModel, PropertyModel propertyModel, Set<ConstraintViolation> ve) {
        if (propertyModel.hasAnnotation(Reference.class)) {
            Class<?> realType = propertyModel.getNormalizedType();
            if (realType.equals(Key.class)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, entityModel, propertyModel, this.getClass(), Sofia.keyNotAllowedAsProperty(new Locale[0])));
            } else {
                try {
                    mapper.getEntityModel(realType);
                }
                catch (NotMappableException ignored) {
                    ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, entityModel, propertyModel, this.getClass(), Sofia.referredTypeMissingId(propertyModel.getFullName(), propertyModel.getType().getName(), new Locale[0])));
                }
            }
        }
    }
}

