/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Polygon;
import com.mongodb.client.model.geojson.Position;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.query.Shape;
import dev.morphia.query.Type;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.sofia.Sofia;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@Deprecated(since="2.0", forRemoval=true)
public enum FilterOperator {
    WITHIN_CIRCLE("$center", new String[0]){

        @Override
        public Filter apply(String prop, Object value) {
            throw new UnsupportedOperationException(Sofia.filterMappingNotSupported((Object)WITHIN_CIRCLE, new Locale[0]));
        }
    }
    ,
    WITHIN_CIRCLE_SPHERE("$centerSphere", new String[0]){

        @Override
        public Filter apply(String prop, Object value) {
            throw new UnsupportedOperationException(Sofia.filterMappingNotSupported((Object)WITHIN_CIRCLE_SPHERE, new Locale[0]));
        }
    }
    ,
    WITHIN_BOX("$box", new String[0]){

        @Override
        public Filter apply(String prop, Object value) {
            if (!(value instanceof Point[])) {
                throw new IllegalArgumentException(Sofia.illegalArgument(value.getClass().getCanonicalName(), Point[].class.getCanonicalName(), new Locale[0]));
            }
            Point[] points = (Point[])value;
            return Filters.box(prop, points[0], points[1]);
        }
    }
    ,
    EQUAL("$eq", new String[]{"=", "=="}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.eq(prop, value);
        }
    }
    ,
    NOT_EQUAL("$ne", new String[]{"!=", "<>"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.ne(prop, value);
        }
    }
    ,
    GREATER_THAN("$gt", new String[]{">"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.gt(prop, value);
        }
    }
    ,
    GREATER_THAN_OR_EQUAL("$gte", new String[]{">="}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.gte(prop, value);
        }
    }
    ,
    LESS_THAN("$lt", new String[]{"<"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.lt(prop, value);
        }
    }
    ,
    LESS_THAN_OR_EQUAL("$lte", new String[]{"<="}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.lte(prop, value);
        }
    }
    ,
    EXISTS("$exists", new String[]{"exists"}){

        @Override
        public Filter apply(String prop, Object value) {
            Filter exists = Filters.exists(prop);
            if (Boolean.FALSE.equals(value)) {
                exists.not();
            }
            return exists;
        }
    }
    ,
    TYPE("$type", new String[]{"type"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.type(prop, (Type)((Object)value));
        }
    }
    ,
    NOT("$not", new String[0]){

        @Override
        public Filter apply(String prop, Object value) {
            throw new UnsupportedOperationException(Sofia.translationNotCurrentlySupported(new Locale[0]));
        }
    }
    ,
    MOD("$mod", new String[]{"mod"}){

        @Override
        public Filter apply(String prop, Object value) {
            long[] values = (long[])value;
            return Filters.mod(prop, values[0], values[1]);
        }
    }
    ,
    SIZE("$size", new String[]{"size"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.size(prop, (Integer)value);
        }
    }
    ,
    IN("$in", new String[]{"in"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.in(prop, (Iterable)value);
        }
    }
    ,
    NOT_IN("$nin", new String[]{"nin"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.nin(prop, value);
        }
    }
    ,
    ALL("$all", new String[]{"all"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.all(prop, value);
        }
    }
    ,
    ELEMENT_MATCH("$elemMatch", new String[]{"elem", "elemMatch"}){

        @Override
        public Filter apply(String prop, Object value) {
            throw new UnsupportedOperationException(Sofia.filterMappingNotSupported((Object)ELEMENT_MATCH, new Locale[0]));
        }
    }
    ,
    WHERE("$where", new String[0]){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.where(value.toString());
        }
    }
    ,
    NEAR("$near", new String[]{"near"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.near(prop, (Point)FilterOperator.convertToGeometry(value));
        }
    }
    ,
    NEAR_SPHERE("$nearSphere", new String[0]){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.nearSphere(prop, (Point)FilterOperator.convertToGeometry(value));
        }
    }
    ,
    GEO_NEAR("$geoNear", new String[]{"geoNear"}){

        @Override
        public Filter apply(String prop, Object value) {
            throw new UnsupportedOperationException("An aggregation operator called in a query context?");
        }
    }
    ,
    GEO_WITHIN("$geoWithin", new String[]{"geoWithin"}){

        @Override
        public Filter apply(String prop, Object value) {
            if (value instanceof Shape) {
                Shape shape = (Shape)value;
                if (shape instanceof Shape.Center) {
                    Shape.Center center = (Shape.Center)shape;
                    if ("$center".equals(center.getGeometry())) {
                        return Filters.center(prop, shape.getPoints()[0], center.getRadius());
                    }
                    if ("$centerSphere".equals(center.getGeometry())) {
                        return Filters.centerSphere(prop, shape.getPoints()[0], center.getRadius());
                    }
                } else {
                    if ("$box".equals(shape.getGeometry())) {
                        return Filters.box(prop, shape.getPoints()[0], shape.getPoints()[1]);
                    }
                    if ("$polygon".equals(shape.getGeometry())) {
                        return Filters.polygon(prop, shape.getPoints());
                    }
                }
                throw new UnsupportedOperationException(Sofia.conversionNotSupported(value.getClass().getCanonicalName(), new Locale[0]));
            }
            if (value instanceof Polygon) {
                return Filters.geoWithin(prop, (Polygon)value);
            }
            if (value instanceof MultiPolygon) {
                return Filters.geoWithin(prop, (MultiPolygon)value);
            }
            throw new UnsupportedOperationException(Sofia.conversionNotSupported(value.getClass().getCanonicalName(), new Locale[0]));
        }
    }
    ,
    INTERSECTS("$geoIntersects", new String[]{"geoIntersects"}){

        @Override
        public Filter apply(String prop, Object value) {
            return Filters.geoIntersects(prop, FilterOperator.convertToGeometry(value));
        }
    };

    private final String value;
    private final List<String> filters;

    private FilterOperator(String val, String ... filterValues) {
        this.value = val;
        this.filters = Arrays.asList(filterValues);
    }

    private static Geometry convertToGeometry(Object value) {
        Geometry converted;
        if (value instanceof double[]) {
            double[] coordinates = (double[])value;
            converted = new Point(new Position(coordinates[0], coordinates[1], new double[0]));
        } else if (value instanceof Geometry) {
            converted = (Geometry)value;
        } else {
            throw new UnsupportedOperationException(Sofia.conversionNotSupported(value.getClass().getCanonicalName(), new Locale[0]));
        }
        return converted;
    }

    public static FilterOperator fromString(String operator) {
        String filter = operator.trim().toLowerCase();
        for (FilterOperator filterOperator : FilterOperator.values()) {
            if (!filterOperator.matches(filter)) continue;
            return filterOperator;
        }
        throw new IllegalArgumentException(String.format("Unknown operator '%s'", operator));
    }

    @MorphiaInternal
    public abstract Filter apply(String var1, Object var2);

    public boolean matches(String filter) {
        return filter != null && this.filters.contains(filter.trim().toLowerCase());
    }

    public String val() {
        return this.value;
    }
}

