/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.CursorType;
import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.CollectionConfigurable;
import dev.morphia.internal.MorphiaInternals;
import dev.morphia.internal.PathTarget;
import dev.morphia.internal.ReadConfigurable;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.query.Meta;
import dev.morphia.query.Projection;
import dev.morphia.query.Sort;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public final class FindOptions
implements ReadConfigurable<FindOptions>,
CollectionConfigurable<FindOptions> {
    private Boolean allowDiskUse;
    private int batchSize;
    private int limit;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private Document variables;
    private Document sort;
    private CursorType cursorType;
    private boolean noCursorTimeout;
    private boolean oplogReplay;
    private boolean partial;
    private Collation collation;
    private BsonValue comment;
    private Document hint;
    private String hintString;
    private Document max;
    private Document min;
    private boolean returnKey;
    private boolean showRecordId;
    private ReadConcern readConcern;
    private ReadPreference readPreference;
    private Projection projection;
    private String queryLogId;
    private String collection;

    public FindOptions allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @MorphiaInternal
    public <T> FindIterable<T> apply(FindIterable<T> iterable, Mapper mapper, Class<?> type) {
        if (this.isLogQuery()) {
            this.logQuery();
        }
        if (this.projection != null) {
            iterable.projection((Bson)this.projection.map(mapper, type));
        }
        MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_1_0, () -> iterable.allowDiskUse(this.allowDiskUse));
        iterable.batchSize(this.batchSize);
        iterable.collation(this.collation);
        MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_6_0, () -> iterable.comment(this.comment));
        if (this.cursorType != null) {
            iterable.cursorType(this.cursorType);
        }
        iterable.hint((Bson)this.hint);
        iterable.hintString(this.hintString);
        iterable.limit(this.limit);
        iterable.max((Bson)this.max);
        iterable.maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
        iterable.maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        iterable.min((Bson)this.min);
        iterable.noCursorTimeout(this.noCursorTimeout);
        iterable.oplogReplay(this.oplogReplay);
        iterable.partial(this.partial);
        iterable.returnKey(this.returnKey);
        iterable.showRecordId(this.showRecordId);
        iterable.skip(this.skip);
        if (this.sort != null) {
            Document mapped = new Document();
            EntityModel model = null;
            try {
                model = mapper.getEntityModel(type);
            }
            catch (NotMappableException notMappableException) {
                // empty catch block
            }
            for (Map.Entry entry : this.sort.entrySet()) {
                Object value = entry.getValue();
                boolean metaScore = value instanceof Document && ((Document)value).get((Object)"$meta") != null;
                mapped.put(new PathTarget(mapper, model, (String)entry.getKey(), model != null && !metaScore).translatedPath(), value);
            }
            iterable.sort((Bson)mapped);
        }
        MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_6_0, () -> iterable.let((Bson)this.variables));
        return iterable;
    }

    public FindOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public FindOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public FindOptions collection(String collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public String collection() {
        return this.collection;
    }

    public FindOptions comment(String comment) {
        this.comment = new BsonString(comment);
        return this;
    }

    public FindOptions comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public FindOptions copy() {
        return new FindOptions().copy(this);
    }

    @MorphiaInternal
    public FindOptions copy(FindOptions original) {
        this.allowDiskUse = original.allowDiskUse;
        this.batchSize = original.batchSize;
        this.collection = original.collection;
        this.limit = original.limit;
        this.maxTimeMS = original.maxTimeMS;
        this.maxAwaitTimeMS = original.maxAwaitTimeMS;
        this.skip = original.skip;
        this.sort = original.sort;
        this.cursorType = original.cursorType;
        this.noCursorTimeout = original.noCursorTimeout;
        this.oplogReplay = original.oplogReplay;
        this.partial = original.partial;
        this.collation = original.collation;
        this.comment = original.comment;
        this.hint = original.hint;
        this.hintString = original.hintString;
        this.max = original.max;
        this.min = original.min;
        this.returnKey = original.returnKey;
        this.showRecordId = original.showRecordId;
        this.readConcern = original.readConcern;
        this.readPreference = original.readPreference;
        this.projection = original.projection;
        this.queryLogId = original.queryLogId;
        return this;
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.cursorType = (CursorType)Assertions.notNull((String)"cursorType", (Object)cursorType);
        return this;
    }

    @Nullable
    @MorphiaInternal
    public CursorType cursorType() {
        return this.cursorType;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public Collation getCollation() {
        return this.collation;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public String getComment() {
        return this.comment.toString();
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public Document getHint() {
        return this.hint;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public int getLimit() {
        return this.limit;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public Document getMax() {
        return this.max;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    @Deprecated(forRemoval=true, since="2.3")
    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public Document getMin() {
        return this.min;
    }

    @Nullable
    @MorphiaInternal
    public Projection getProjection() {
        return this.projection;
    }

    @MorphiaInternal
    @Deprecated(forRemoval=true, since="2.3")
    public String getQueryLogId() {
        return this.queryLogId;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public int getSkip() {
        return this.skip;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    public Document getSort() {
        return this.sort;
    }

    public int hashCode() {
        return Objects.hash(this.allowDiskUse, this.batchSize, this.limit, this.maxTimeMS, this.maxAwaitTimeMS, this.skip, this.sort, this.cursorType, this.noCursorTimeout, this.oplogReplay, this.partial, this.collation, this.comment, this.hint, this.hintString, this.max, this.min, this.returnKey, this.showRecordId, this.readConcern, this.readPreference, this.projection, this.queryLogId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FindOptions)) {
            return false;
        }
        FindOptions that = (FindOptions)o;
        return this.batchSize == that.batchSize && this.limit == that.limit && this.maxTimeMS == that.maxTimeMS && this.maxAwaitTimeMS == that.maxAwaitTimeMS && this.skip == that.skip && this.noCursorTimeout == that.noCursorTimeout && this.oplogReplay == that.oplogReplay && this.partial == that.partial && this.returnKey == that.returnKey && this.showRecordId == that.showRecordId && Objects.equals(this.allowDiskUse, that.allowDiskUse) && Objects.equals(this.sort, that.sort) && this.cursorType == that.cursorType && Objects.equals(this.collation, that.collation) && Objects.equals(this.comment, that.comment) && Objects.equals(this.hint, that.hint) && Objects.equals(this.hintString, that.hintString) && Objects.equals(this.max, that.max) && Objects.equals(this.min, that.min) && Objects.equals(this.readConcern, that.readConcern) && Objects.equals(this.readPreference, that.readPreference) && Objects.equals(this.projection, that.projection) && Objects.equals(this.queryLogId, that.queryLogId);
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOptions hint(Document hint) {
        this.hint = new Document((Map)hint);
        return this;
    }

    public FindOptions hint(String hint) {
        this.hintString(hint);
        return this;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public FindOptions hint(DBObject hint) {
        return this.hint(new Document(hint.toMap()));
    }

    public FindOptions hintString(String hint) {
        this.hintString = hint;
        return this;
    }

    @MorphiaInternal
    public boolean isLogQuery() {
        return this.queryLogId != null;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean isPartial() {
        return this.partial;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean isReturnKey() {
        return this.returnKey;
    }

    @Deprecated(forRemoval=true, since="2.3")
    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOptions let(Document variables) {
        this.variables = new Document((Map)variables);
        return this;
    }

    @MorphiaInternal
    public String queryLogId() {
        return this.queryLogId;
    }

    public FindOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public FindOptions logQuery() {
        this.queryLogId = new ObjectId().toString();
        this.comment(Sofia.loggedQuery(this.queryLogId, new Locale[0]));
        return this;
    }

    public FindOptions max(Document max) {
        this.max = new Document((Map)max);
        return this;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public FindOptions max(DBObject max) {
        return this.hint(new Document(max.toMap()));
    }

    public FindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        Assertions.isTrueArgument((String)"maxAwaitTime > = 0", (maxAwaitTime >= 0L ? 1 : 0) != 0);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        Assertions.isTrueArgument((String)"maxTime > = 0", (maxTime >= 0L ? 1 : 0) != 0);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public FindOptions min(Document min) {
        this.min = new Document((Map)min);
        return this;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public FindOptions min(DBObject min) {
        return this.hint(new Document(min.toMap()));
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public FindOptions partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public Projection projection() {
        if (this.projection == null) {
            this.projection = new Projection(this);
        }
        return this.projection;
    }

    @Override
    public ReadConcern readConcern() {
        return this.readConcern;
    }

    @Override
    public ReadPreference readPreference() {
        return this.readPreference;
    }

    @Override
    public FindOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    @Override
    public FindOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.3")
    @MorphiaInternal
    public Document sort() {
        return this.sort;
    }

    public FindOptions returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public FindOptions showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public FindOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", FindOptions.class.getSimpleName() + "[", "]").add("allowDiskUse=" + this.allowDiskUse).add("batchSize=" + this.batchSize).add("limit=" + this.limit).add("maxTimeMS=" + this.maxTimeMS).add("maxAwaitTimeMS=" + this.maxAwaitTimeMS).add("skip=" + this.skip).add("sort=" + this.sort).add("cursorType=" + this.cursorType).add("noCursorTimeout=" + this.noCursorTimeout).add("oplogReplay=" + this.oplogReplay).add("partial=" + this.partial).add("collation=" + this.collation).add("comment='" + this.comment + "'").add("hint=" + this.hint).add("max=" + this.max).add("min=" + this.min).add("returnKey=" + this.returnKey).add("showRecordId=" + this.showRecordId).add("readPreference=" + this.readPreference).add("queryLogId='" + this.queryLogId + "'").add("projection=" + this.projection).toString();
    }

    public FindOptions sort(Meta meta) {
        this.projection().project(meta);
        return this.sort(meta.toDatabase());
    }

    public FindOptions sort(Meta meta, Sort ... sorts) {
        this.projection().project(meta);
        this.sort(meta.toDatabase());
        for (Sort sort : sorts) {
            this.sort.append(sort.getField(), (Object)sort.getOrder());
        }
        return this;
    }

    public FindOptions sort(Document sort) {
        this.sort = new Document((Map)sort);
        return this;
    }

    public FindOptions sort(Sort ... sorts) {
        this.sort = new Document();
        for (Sort sort : sorts) {
            this.sort.append(sort.getField(), (Object)sort.getOrder());
        }
        return this;
    }
}

