/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.client.model.geojson.CoordinateReferenceSystem;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FilterOperator;
import java.util.Map;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;

final class Geo2dSphereCriteria
extends FieldCriteria {
    private final Geometry geometry;
    private Document options;
    private CoordinateReferenceSystem crs;

    private Geo2dSphereCriteria(Datastore datastore, String field, FilterOperator operator, Geometry geometry, EntityModel model, boolean validating) {
        super(datastore, field, operator, geometry, model, validating);
        this.geometry = geometry;
    }

    static Geo2dSphereCriteria geo(Datastore datastore, String field, FilterOperator operator, Geometry value, EntityModel model, boolean validating) {
        return new Geo2dSphereCriteria(datastore, field, operator, value, model, validating);
    }

    @Override
    public Document toDocument() {
        Document query;
        FilterOperator operator = this.getOperator();
        DocumentWriter writer = new DocumentWriter(this.getDatastore().getMapper().getConfig());
        this.getDatastore().getCodecRegistry().get(this.geometry.getClass()).encode((BsonWriter)writer, (Object)this.geometry, EncoderContext.builder().build());
        Document document = new Document("$geometry", (Object)writer.getDocument());
        if (operator == FilterOperator.NEAR || operator == FilterOperator.NEAR_SPHERE) {
            if (this.options != null) {
                document.putAll((Map)this.options);
            }
            query = new Document(FilterOperator.NEAR.val(), (Object)document);
        } else if (operator == FilterOperator.GEO_WITHIN || operator == FilterOperator.INTERSECTS) {
            query = new Document(operator.val(), (Object)document);
            if (this.crs != null) {
                ((Document)document.get((Object)"$geometry")).put("crs", (Object)this.crs);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Operator %s not supported for geo-query", operator.val()));
        }
        return new Document(this.getField(), (Object)query);
    }

    Geo2dSphereCriteria addCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
        return this;
    }

    private Geo2dSphereCriteria manageOption(String key, @Nullable Object value) {
        if (this.options == null) {
            this.options = new Document();
        }
        if (value == null) {
            this.options.remove((Object)key);
        } else {
            this.options.put(key, value);
        }
        return this;
    }

    Geo2dSphereCriteria maxDistance(@Nullable Double maxDistance) {
        return this.manageOption("$maxDistance", maxDistance);
    }

    Geo2dSphereCriteria minDistance(@Nullable Double minDistance) {
        return this.manageOption("$minDistance", minDistance);
    }
}

