/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.DatastoreImpl;
import dev.morphia.DeleteOptions;
import dev.morphia.ModifyOptions;
import dev.morphia.UpdateOptions;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.MorphiaInternals;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.query.CountOptions;
import dev.morphia.query.Criteria;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.CriteriaContainerImpl;
import dev.morphia.query.CriteriaJoin;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FieldEndImpl;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Modify;
import dev.morphia.query.PipelineUpdate;
import dev.morphia.query.Projection;
import dev.morphia.query.Query;
import dev.morphia.query.Update;
import dev.morphia.query.UpdateBase;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateOpsImpl;
import dev.morphia.query.ValidationException;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.query.internal.MorphiaKeyCursor;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.sofia.Sofia;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
@Deprecated
public class LegacyQuery<T>
implements CriteriaContainer,
Query<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyQuery.class);
    private final DatastoreImpl datastore;
    private final Class<T> type;
    private final String collectionName;
    private final MongoCollection<T> collection;
    private final EntityModel model;
    private final CriteriaContainer compoundContainer;
    private boolean validateName = true;
    private boolean validateType = true;
    private Document baseQuery;
    @Deprecated
    private FindOptions options;
    private FindOptions lastOptions;
    private ValidationException invalid;

    protected LegacyQuery(Datastore datastore, @Nullable String collectionName, Class<T> type) {
        this.type = type;
        this.datastore = (DatastoreImpl)datastore;
        this.model = datastore.getMapper().getEntityModel(type);
        if (collectionName != null) {
            this.collection = datastore.getDatabase().getCollection(collectionName, type);
            this.collectionName = collectionName;
        } else {
            this.collection = datastore.getCollection(type);
            this.collectionName = this.collection.getNamespace().getCollectionName();
        }
        this.compoundContainer = new CriteriaContainerImpl(this, CriteriaJoin.AND);
    }

    @Override
    public void add(Criteria ... criteria) {
        for (Criteria c : criteria) {
            c.attach(this);
            this.compoundContainer.add(c);
        }
    }

    @Override
    public CriteriaContainer and(Criteria ... criteria) {
        return this.compoundContainer.and(criteria);
    }

    @Override
    public FieldEnd<? extends CriteriaContainer> criteria(String field) {
        CriteriaContainerImpl container = new CriteriaContainerImpl(this, CriteriaJoin.AND);
        this.add(container);
        return new FieldEndImpl<CriteriaContainerImpl>(this.datastore, field, container, this.model, this.isValidatingNames());
    }

    @MorphiaInternal
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void invalid(ValidationException e) {
        this.invalid = e;
    }

    @Override
    public CriteriaContainer or(Criteria ... criteria) {
        return this.compoundContainer.or(criteria);
    }

    @Override
    public void remove(Criteria criteria) {
        this.compoundContainer.remove(criteria);
    }

    @Override
    public void attach(CriteriaContainer container) {
        this.compoundContainer.attach(container);
    }

    @Override
    public String getFieldName() {
        throw new UnsupportedOperationException("this method is unused on a Query");
    }

    @Override
    public long count(CountOptions options) {
        return this.datastore.operations().countDocuments(this.datastore.configureCollection(options, this.collection), this.getQueryDocument(), options);
    }

    @Override
    public long count() {
        return this.count(new CountOptions());
    }

    @Override
    @Deprecated(since="2.0", forRemoval=true)
    public MorphiaCursor<T> execute() {
        return this.iterator();
    }

    @Override
    public DeleteResult delete(DeleteOptions options) {
        MongoCollection<T> collection = this.datastore.configureCollection(options, this.collection);
        if (options.multi()) {
            return this.datastore.operations().deleteMany(collection, this.getQueryDocument(), options);
        }
        return this.datastore.operations().deleteOne(collection, this.getQueryDocument(), options);
    }

    @Override
    public Map<String, Object> explain(FindOptions options, @Nullable ExplainVerbosity verbosity) {
        MongoCollection<T> collection = this.datastore.configureCollection(options, this.collection);
        return (Map)((Object)MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_2_0, () -> verbosity == null ? this.iterable(options, collection).explain() : this.iterable(options, collection).explain(verbosity), () -> new LinkedHashMap(this.datastore.getDatabase().runCommand((Bson)new Document("explain", (Object)new Document("find", (Object)collection.getNamespace().getCollectionName()).append("filter", (Object)this.getQueryDocument()))))));
    }

    @Override
    public Query<T> disableValidation() {
        this.validateName = false;
        this.validateType = false;
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validateName = true;
        this.validateType = true;
        return this;
    }

    @Override
    @Deprecated(since="2.0", forRemoval=true)
    public MorphiaCursor<T> execute(FindOptions options) {
        return this.iterator(options);
    }

    @Override
    public String getLoggedQuery() {
        if (this.lastOptions != null && this.lastOptions.isLogQuery()) {
            Document command;
            Document filter;
            String json = "{}";
            Document first = (Document)this.datastore.getDatabase().getCollection("system.profile").find((Bson)new Document("command.comment", (Object)("logged query: " + this.lastOptions.queryLogId())), Document.class).projection((Bson)new Document("command.filter", (Object)1)).first();
            if (first != null && (filter = (Document)(command = (Document)first.get((Object)"command")).get((Object)"filter")) != null) {
                json = filter.toJson((Encoder)this.datastore.getCodecRegistry().get(Document.class));
            }
            return json;
        }
        throw new IllegalStateException(Sofia.queryNotLogged(new Locale[0]));
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        try {
            return new FieldEndImpl<LegacyQuery>(this.datastore, name, this, this.model, this.isValidatingNames());
        }
        catch (ValidationException e) {
            this.invalid = e;
            throw e;
        }
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        FilterOperator op = parts.length == 2 ? this.translate(parts[1]) : FilterOperator.EQUAL;
        this.add(new FieldCriteria(this.datastore, prop, op, value, this.datastore.getMapper().getEntityModel(this.getEntityClass()), this.isValidatingNames()));
        return this;
    }

    @Override
    public T findAndDelete(FindAndDeleteOptions options) {
        MongoCollection<T> mongoCollection = this.datastore.configureCollection(options, this.collection);
        return this.datastore.operations().findOneAndDelete(mongoCollection, this.getQueryDocument(), options);
    }

    @Override
    @MorphiaInternal
    public Class<T> getEntityClass() {
        return this.type;
    }

    @Override
    public T first() {
        return this.first(new FindOptions());
    }

    @Override
    public T first(FindOptions options) {
        this.checkValidity();
        try (MorphiaCursor<T> it = this.iterator(options.copy().limit(1));){
            Object object = it.tryNext();
            return (T)object;
        }
    }

    @Override
    public Modify<T> modify(UpdateOperator first, UpdateOperator ... updates) {
        return new Modify<T>(this.datastore, this.datastore.configureCollection(this.options, this.collection), this, this.type, UpdateBase.coalesce(first, updates));
    }

    @Override
    public T modify(ModifyOptions options, UpdateOperator ... updates) {
        return new Modify<T>(this.datastore, this.datastore.configureCollection(options, this.collection), this, this.type, List.of(updates)).execute(options);
    }

    @MorphiaInternal
    public boolean isValidate() {
        return this.validateName;
    }

    @Override
    public MorphiaCursor<T> iterator(FindOptions options) {
        return new MorphiaCursor<T>(this.prepareCursor(options, this.datastore.configureCollection(options, this.collection)));
    }

    @Override
    public MorphiaKeyCursor<T> keys(FindOptions options) {
        FindOptions returnKey = new FindOptions().copy(options).projection().include("_id");
        return new MorphiaKeyCursor<T>(this.prepareCursor(returnKey, this.datastore.getDatabase().getCollection(this.getCollectionName())), this.datastore, this.type, this.getCollectionName());
    }

    @Override
    public MorphiaKeyCursor<T> keys() {
        return this.keys(new FindOptions());
    }

    @Override
    @Deprecated
    public Modify<T> modify(UpdateOperations<T> operations) {
        return new Modify<T>(this.datastore, this.collection, this, this.type, (UpdateOpsImpl)operations);
    }

    @Override
    public Query<T> search(String search, String language) {
        this.criteria("$text").equal(new Document("$search", (Object)search).append("$language", (Object)language));
        return this;
    }

    @Override
    public Query<T> retrieveKnownFields() {
        this.getOptions().projection().knownFields();
        return this;
    }

    @Override
    public Query<T> search(String search) {
        this.criteria("$text").equal(new Document("$search", (Object)search));
        return this;
    }

    @Override
    @Deprecated
    public Update<T> update(List<UpdateOperator> updates) {
        return new Update<T>(this.datastore, this.collection, this, this.type, updates);
    }

    @Override
    public Update<T> update(UpdateOperator first, UpdateOperator ... updates) {
        return new Update<T>(this.datastore, this.collection, this, this.type, UpdateBase.coalesce(first, updates));
    }

    @Override
    @Deprecated(since="2.0", forRemoval=true)
    public Update<T> update(UpdateOperations<T> operations) {
        return new Update<T>(this.datastore, this.collection, this, this.type, (UpdateOpsImpl)operations);
    }

    @Override
    public UpdateResult update(UpdateOptions options, Stage ... updates) {
        return new PipelineUpdate<T>(this.datastore, this.datastore.configureCollection(options, this.collection), this, List.of(updates)).execute(options);
    }

    @Override
    public UpdateResult update(UpdateOptions options, UpdateOperator ... updates) {
        return new Update<T>(this.datastore, this.datastore.configureCollection(options, this.collection), this, this.type, List.of(updates)).execute(options);
    }

    @Nullable
    @MorphiaInternal
    public Document getFieldsObject() {
        Projection projection = this.getOptions().getProjection();
        return projection != null ? projection.map(this.datastore.getMapper(), this.type) : null;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.validateName, this.validateType, this.baseQuery, this.getOptions(), this.compoundContainer, this.getCollectionName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyQuery)) {
            return false;
        }
        LegacyQuery query = (LegacyQuery)o;
        return this.validateName == query.validateName && this.validateType == query.validateType && Objects.equals(this.type, query.type) && Objects.equals(this.baseQuery, query.baseQuery) && Objects.equals(this.getOptions(), query.getOptions()) && Objects.equals(this.compoundContainer, query.compoundContainer) && Objects.equals(this.getCollectionName(), query.getCollectionName());
    }

    @Nullable
    @MorphiaInternal
    public Document getSort() {
        return this.options != null ? this.options.sort() : null;
    }

    @Override
    @MorphiaInternal
    public Document toDocument() {
        Document query = this.getQueryDocument();
        EntityModel model = this.datastore.getMapper().getEntityModel(this.getEntityClass());
        Entity entityAnnotation = model.getEntityAnnotation();
        if (entityAnnotation != null && entityAnnotation.useDiscriminator() && !query.containsKey((Object)"_id") && !query.containsKey((Object)model.getDiscriminatorKey())) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(model.getDiscriminator());
            for (EntityModel subtype : this.datastore.getMapper().getEntityModel(this.getEntityClass()).getSubtypes()) {
                values.add(subtype.getDiscriminator());
            }
            query.put(model.getDiscriminatorKey(), (Object)new Document("$in", values));
        }
        return query;
    }

    public String toString() {
        return this.getOptions().getProjection() == null ? this.getQueryDocument().toString() : String.format("{ %s, %s }", this.getQueryDocument(), this.getFieldsObject());
    }

    public boolean isValidatingNames() {
        return this.validateName;
    }

    public void setQueryObject(Document query) {
        this.baseQuery = new Document((Map)query);
    }

    protected Datastore getDatastore() {
        return this.datastore;
    }

    private String getCollectionName() {
        return this.collectionName;
    }

    private Document getQueryDocument() {
        this.checkValidity();
        try {
            Document obj = new Document();
            if (this.baseQuery != null) {
                obj.putAll((Map)this.baseQuery);
            }
            obj.putAll((Map)this.compoundContainer.toDocument());
            this.datastore.getMapper().updateQueryWithDiscriminators(this.datastore.getMapper().getEntityModel(this.getEntityClass()), obj);
            return obj;
        }
        catch (ValidationException e) {
            this.invalid = e;
            throw e;
        }
    }

    private void checkValidity() {
        if (this.invalid != null) {
            throw this.invalid;
        }
    }

    @NonNull
    private <E> FindIterable<E> iterable(FindOptions options, MongoCollection<E> collection) {
        Document query = this.toDocument();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Running query(%s) : %s, options: %s,", this.getCollectionName(), query.toJson(), options));
        }
        if (options.cursorType() != null && options.cursorType() != CursorType.NonTailable && options.sort() != null) {
            LOG.warn("Sorting on tail is not allowed.");
        }
        return this.datastore.operations().find(collection, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> MongoCursor<E> prepareCursor(FindOptions options, MongoCollection<E> collection) {
        Document oldProfile = null;
        this.lastOptions = options;
        if (options.isLogQuery()) {
            oldProfile = this.datastore.getDatabase().runCommand((Bson)new Document("profile", (Object)2).append("slowms", (Object)0));
        }
        try {
            MongoCursor mongoCursor = options.apply(this.iterable(options, collection), this.datastore.getMapper(), this.type).iterator();
            return mongoCursor;
        }
        finally {
            if (options.isLogQuery()) {
                this.datastore.getDatabase().runCommand((Bson)new Document("profile", oldProfile.get((Object)"was")).append("slowms", oldProfile.get((Object)"slowms")).append("sampleRate", oldProfile.get((Object)"sampleRate")));
            }
        }
    }

    private FilterOperator translate(String operator) {
        return FilterOperator.fromString(operator);
    }

    FindOptions getOptions() {
        if (this.options == null) {
            this.options = new FindOptions();
        }
        return this.options;
    }
}

