/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.ExplainVerbosity;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.DatastoreImpl;
import dev.morphia.DeleteOptions;
import dev.morphia.ModifyOptions;
import dev.morphia.UpdateOptions;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.CountOptions;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FieldEndImpl;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Modify;
import dev.morphia.query.PipelineUpdate;
import dev.morphia.query.Query;
import dev.morphia.query.Shape;
import dev.morphia.query.Update;
import dev.morphia.query.UpdateBase;
import dev.morphia.query.ValidationException;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.filters.NearFilter;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.query.internal.MorphiaKeyCursor;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MorphiaInternal
class MorphiaQuery<T>
implements Query<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MorphiaQuery.class);
    private final DatastoreImpl datastore;
    private final Class<T> type;
    private final Mapper mapper;
    private final List<Filter> filters = new ArrayList<Filter>();
    private final Document seedQuery;
    private String collectionName;
    private MongoCollection<T> collection;
    private ValidationException invalid;
    private boolean validate = true;
    private FindOptions lastOptions;

    protected MorphiaQuery(Datastore datastore, @Nullable String collectionName, Class<T> type) {
        this.type = type;
        this.datastore = (DatastoreImpl)datastore;
        this.mapper = this.datastore.getMapper();
        this.seedQuery = null;
        this.collectionName = collectionName;
        if (collectionName != null) {
            this.collection = datastore.getDatabase().getCollection(collectionName, type);
        } else if (this.mapper.isMappable(type)) {
            this.collection = datastore.getCollection(type);
            this.collectionName = this.collection.getNamespace().getCollectionName();
        }
    }

    protected MorphiaQuery(Datastore datastore, Class<T> type, @Nullable Document query) {
        this.type = type;
        this.datastore = (DatastoreImpl)datastore;
        this.seedQuery = query;
        this.mapper = this.datastore.getMapper();
        this.collection = datastore.getCollection(type);
        this.collectionName = this.collection.getNamespace().getCollectionName();
    }

    static <V> V legacyOperation() {
        throw new UnsupportedOperationException(Sofia.legacyOperation(new Locale[0]));
    }

    @Override
    public Query<T> filter(Filter ... additional) {
        for (Filter filter : additional) {
            this.filters.add(filter.entityType(this.getEntityClass()).isValidating(this.validate));
        }
        return this;
    }

    @Override
    public long count() {
        return this.count(new CountOptions());
    }

    @Override
    public long count(CountOptions options) {
        MongoCollection<T> collection = this.datastore.configureCollection(options, this.collection);
        return this.datastore.operations().countDocuments(collection, this.getQueryDocument(), options);
    }

    @Override
    public DeleteResult delete(DeleteOptions options) {
        MongoCollection<T> collection = this.datastore.configureCollection(options, this.collection);
        if (options.multi()) {
            return this.datastore.operations().deleteMany(collection, this.getQueryDocument(), options);
        }
        return this.datastore.operations().deleteOne(collection, this.getQueryDocument(), options);
    }

    @Override
    public Query<T> disableValidation() {
        this.validate = false;
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validate = true;
        return this;
    }

    @Override
    public Map<String, Object> explain(FindOptions options, @Nullable ExplainVerbosity verbosity) {
        return verbosity == null ? this.iterable(options, this.collection).explain() : this.iterable(options, this.collection).explain(verbosity);
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return new MorphiaQueryFieldEnd(name);
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        FilterOperator op = parts.length == 2 ? FilterOperator.fromString(parts[1]) : FilterOperator.EQUAL;
        return this.filter(op.apply(parts[0].trim(), value));
    }

    @Override
    public String getLoggedQuery() {
        if (this.lastOptions != null && this.lastOptions.isLogQuery()) {
            Document command;
            String json = "{}";
            Document filter = new Document("command.comment", (Object)Sofia.loggedQuery(this.lastOptions.queryLogId(), new Locale[0]));
            Document first = (Document)this.datastore.getDatabase().getCollection("system.profile").find((Bson)filter, Document.class).projection((Bson)new Document("command.filter", (Object)1)).first();
            if (first != null && (filter = (Document)(command = (Document)first.get((Object)"command")).get((Object)"filter")) != null) {
                json = filter.toJson((Encoder)this.datastore.getCodecRegistry().get(Document.class));
            }
            return json;
        }
        throw new IllegalStateException(Sofia.queryNotLogged(new Locale[0]));
    }

    @Override
    public T findAndDelete(FindAndDeleteOptions options) {
        MongoCollection<T> mongoCollection = this.datastore.configureCollection(options, this.collection);
        return this.datastore.operations().findOneAndDelete(mongoCollection, this.getQueryDocument(), options);
    }

    @Override
    public T first() {
        return this.first(new FindOptions());
    }

    @Override
    public T first(FindOptions options) {
        try (MorphiaCursor<T> it = this.iterator(options.copy().limit(1));){
            Object object = it.tryNext();
            return (T)object;
        }
    }

    @Override
    public Class<T> getEntityClass() {
        return this.type;
    }

    @Override
    public Modify<T> modify(UpdateOperator first, UpdateOperator ... updates) {
        return new Modify<T>(this.datastore, this.collection, this, this.getEntityClass(), UpdateBase.coalesce(first, updates));
    }

    @Override
    public T modify(ModifyOptions options, UpdateOperator ... updates) {
        return new Modify<T>(this.datastore, this.datastore.configureCollection(options, this.collection), this, this.getEntityClass(), List.of(updates)).execute(options);
    }

    @MorphiaInternal
    public boolean isValidate() {
        return this.validate;
    }

    @Override
    public MorphiaCursor<T> iterator(FindOptions options) {
        return new MorphiaCursor<T>(this.prepareCursor(options, this.collection));
    }

    @Override
    public MorphiaKeyCursor<T> keys() {
        return this.keys(new FindOptions());
    }

    @Override
    public MorphiaKeyCursor<T> keys(FindOptions options) {
        FindOptions includeId = new FindOptions().copy(options).projection().include("_id");
        return new MorphiaKeyCursor<T>(this.prepareCursor(includeId, this.datastore.getDatabase().getCollection(this.getCollectionName())), this.datastore, this.type, this.getCollectionName());
    }

    @Override
    public Query<T> search(String searchText) {
        return this.filter(Filters.text(searchText));
    }

    @Override
    public Query<T> search(String searchText, String language) {
        return this.filter(Filters.text(searchText).language(language));
    }

    @Override
    @MorphiaInternal
    public Document toDocument() {
        return this.getQueryDocument();
    }

    @Override
    @Deprecated
    public Update<T> update(List<UpdateOperator> updates) {
        if (this.invalid != null) {
            throw this.invalid;
        }
        try {
            return new Update<T>(this.datastore, this.collection, this, this.type, updates);
        }
        catch (ValidationException e) {
            this.invalid = e;
            throw e;
        }
    }

    @Override
    public Update<T> update(UpdateOperator first, UpdateOperator ... updates) {
        if (this.invalid != null) {
            throw this.invalid;
        }
        try {
            return new Update<T>(this.datastore, this.collection, this, this.type, UpdateBase.coalesce(first, updates));
        }
        catch (ValidationException e) {
            this.invalid = e;
            throw e;
        }
    }

    @Override
    public UpdateResult update(UpdateOptions options, Stage ... updates) {
        if (this.invalid != null) {
            throw this.invalid;
        }
        try {
            return new PipelineUpdate<T>(this.datastore, this.datastore.configureCollection(options, this.collection), this, Arrays.asList(updates)).execute(options);
        }
        catch (ValidationException e) {
            this.invalid = e;
            throw e;
        }
    }

    @Override
    public UpdateResult update(UpdateOptions options, UpdateOperator ... updates) {
        if (this.invalid != null) {
            throw this.invalid;
        }
        return new Update<T>(this.datastore, this.datastore.configureCollection(options, this.collection), this, this.type, Arrays.asList(updates)).execute(options);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.validate, this.getCollectionName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MorphiaQuery)) {
            return false;
        }
        MorphiaQuery query20 = (MorphiaQuery)o;
        return this.validate == query20.validate && Objects.equals(this.type, query20.type) && Objects.equals(this.getCollectionName(), query20.getCollectionName());
    }

    public String toString() {
        return new StringJoiner(", ", MorphiaQuery.class.getSimpleName() + "[", "]").add("clazz=" + this.type.getSimpleName()).add("query=" + this.getQueryDocument()).toString();
    }

    private String getCollectionName() {
        return this.collectionName;
    }

    @NonNull
    private <E> FindIterable<E> iterable(FindOptions findOptions, MongoCollection<E> collection) {
        Document query = this.toDocument();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Running query(%s) : %s, options: %s,", this.getCollectionName(), query, findOptions));
        }
        MongoCollection<E> updated = this.datastore.configureCollection(findOptions, collection);
        return this.datastore.operations().find(updated, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> MongoCursor<E> prepareCursor(FindOptions options, MongoCollection<E> collection) {
        Document oldProfile = null;
        this.lastOptions = options;
        if (options.isLogQuery()) {
            oldProfile = this.datastore.getDatabase().runCommand((Bson)new Document("profile", (Object)2).append("slowms", (Object)0));
        }
        try {
            MongoCursor mongoCursor = options.apply(this.iterable(options, collection), this.mapper, this.type).iterator();
            return mongoCursor;
        }
        finally {
            if (options.isLogQuery()) {
                this.datastore.getDatabase().runCommand((Bson)new Document("profile", oldProfile.get((Object)"was")).append("slowms", oldProfile.get((Object)"slowms")).append("sampleRate", oldProfile.get((Object)"sampleRate")));
            }
        }
    }

    Document getQueryDocument() {
        if (this.invalid != null) {
            throw this.invalid;
        }
        try {
            DocumentWriter writer = new DocumentWriter(this.mapper.getConfig(), this.seedQuery);
            ExpressionHelper.document(writer, () -> {
                EncoderContext context = EncoderContext.builder().build();
                for (Filter filter : this.filters) {
                    filter.encode(this.datastore, writer, context);
                }
            });
            Document query = writer.getDocument();
            if (this.mapper.isMappable(this.getEntityClass())) {
                this.mapper.updateQueryWithDiscriminators(this.mapper.getEntityModel(this.getEntityClass()), query);
            }
            return query;
        }
        catch (ValidationException e) {
            this.invalid = e;
            throw e;
        }
    }

    @Deprecated(since="2.0", forRemoval=true)
    private class MorphiaQueryFieldEnd
    extends FieldEndImpl {
        private final String name;

        private MorphiaQueryFieldEnd(String name) {
            super(MorphiaQuery.this.datastore, name, MorphiaQuery.this, MorphiaQuery.this.mapper.getEntityModel(MorphiaQuery.this.getEntityClass()), MorphiaQuery.this.validate);
            this.name = name;
        }

        @Override
        public CriteriaContainer within(Shape shape) {
            Filter converted;
            if (shape instanceof Shape.Center) {
                Shape.Center center = (Shape.Center)shape;
                converted = Filters.center(this.getField(), center.getCenter(), center.getRadius());
            } else if (shape.getGeometry().equals("$box")) {
                Point[] points = shape.getPoints();
                converted = Filters.box(this.getField(), points[0], points[1]);
            } else if (shape.getGeometry().equals("$polygon")) {
                converted = Filters.polygon(this.getField(), shape.getPoints());
            } else {
                throw new UnsupportedOperationException(Sofia.conversionNotSupported(shape.getGeometry(), new Locale[0]));
            }
            if (this.isNot()) {
                converted.not();
            }
            MorphiaQuery.this.filter(converted);
            return MorphiaQuery.this;
        }

        protected MorphiaQuery<T> addCriteria(FilterOperator op, Object val, boolean not) {
            Filter converted = op.apply(this.name, val);
            if (not) {
                converted.not();
            }
            MorphiaQuery.this.filter(converted);
            return MorphiaQuery.this;
        }

        protected CriteriaContainer addGeoCriteria(FilterOperator op, Object val, Map opts) {
            NearFilter apply = (NearFilter)op.apply(this.name, val);
            apply.applyOpts(opts);
            MorphiaQuery.this.filter(apply);
            return MorphiaQuery.this;
        }
    }
}

