/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.codec.pojo.PropertyHandler;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.LegacyQuery;
import java.util.StringJoiner;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;

@MorphiaInternal
public class OperationTarget {
    private final PathTarget target;
    private final Object value;

    @MorphiaInternal
    public OperationTarget(@Nullable PathTarget target, @Nullable Object value) {
        this.target = target;
        this.value = value;
    }

    @MorphiaInternal
    public Object encode(Datastore datastore) {
        if (this.target == null) {
            if (this.value == null) {
                throw new NullPointerException();
            }
            return this.value;
        }
        PropertyModel mappedField = this.target.target();
        Object mappedValue = this.value;
        PropertyModel model = mappedField != null ? mappedField.getEntityModel().getProperty(mappedField.getName()) : null;
        Codec<?> cachedCodec = null;
        if (model != null && !(mappedValue instanceof LegacyQuery)) {
            cachedCodec = model.specializeCodec(datastore);
        }
        if (cachedCodec instanceof PropertyHandler) {
            mappedValue = ((PropertyHandler)cachedCodec).encode(mappedValue);
        } else {
            DocumentWriter writer = new DocumentWriter(datastore.getMapper().getConfig());
            Object finalMappedValue = mappedValue;
            ExpressionHelper.document(writer, () -> ExpressionHelper.value(datastore, writer, "mapped", finalMappedValue, EncoderContext.builder().build()));
            mappedValue = writer.getDocument().get((Object)"mapped");
        }
        return new Document(this.target.translatedPath(), mappedValue);
    }

    @Nullable
    public PathTarget getTarget() {
        return this.target;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return new StringJoiner(", ", OperationTarget.class.getSimpleName() + "[", "]").add("target=" + this.target).add("value=" + this.value).toString();
    }
}

