/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import dev.morphia.DatastoreImpl;
import dev.morphia.UpdateOptions;
import dev.morphia.aggregation.stages.Stage;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.query.Query;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class PipelineUpdate<T> {
    private final Query<T> query;
    private final MongoCollection<T> collection;
    private final List<Stage> updates = new ArrayList<Stage>();
    private final DatastoreImpl datastore;

    PipelineUpdate(DatastoreImpl datastore, MongoCollection<T> collection, Query<T> query, List<Stage> updates) {
        this.datastore = datastore;
        this.collection = collection;
        this.query = query;
        this.updates.addAll(updates);
    }

    public UpdateResult execute() {
        return this.execute(new UpdateOptions());
    }

    public UpdateResult execute(UpdateOptions options) {
        List<Document> updateOperations = this.toDocument();
        Document queryObject = this.query.toDocument();
        MongoCollection<T> mongoCollection = this.datastore.configureCollection(options, this.collection);
        if (options.multi()) {
            return this.datastore.operations().updateMany(mongoCollection, queryObject, updateOperations, options);
        }
        return this.datastore.operations().updateOne(mongoCollection, queryObject, updateOperations, options);
    }

    private List<Document> toDocument() {
        CodecRegistry registry = this.datastore.getCodecRegistry();
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Stage update : this.updates) {
            DocumentWriter writer = new DocumentWriter(this.datastore.getMapper().getConfig());
            Codec codec = registry.get(update.getClass());
            codec.encode((BsonWriter)writer, (Object)update, EncoderContext.builder().build());
            documents.add(writer.getDocument());
        }
        return documents;
    }
}

