/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.lang.Nullable;
import dev.morphia.annotations.Entity;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.query.ArraySlice;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Meta;
import dev.morphia.query.ValidationException;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.bson.Document;

public class Projection {
    private final FindOptions options;
    private List<String> includes;
    private List<String> excludes;
    private String arrayField;
    private ArraySlice slice;
    private Meta meta;
    private Boolean knownFields;

    Projection(FindOptions options) {
        this.options = options;
    }

    public FindOptions exclude(String ... fields) {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>();
        }
        this.excludes.addAll(List.of(fields));
        this.validateProjections();
        return this.options;
    }

    private void validateProjections() {
        if (!(this.includes == null && this.excludes == null || this.slice == null && this.meta == null)) {
            throw new ValidationException(Sofia.mixedModeProjections(new Locale[0]));
        }
        if (this.slice != null && this.meta != null) {
            throw new ValidationException(Sofia.mixedModeProjections(new Locale[0]));
        }
        if (!(this.includes == null || this.excludes == null || this.excludes.size() <= 1 && "_id".equals(this.excludes.get(0)))) {
            throw new ValidationException(Sofia.mixedProjections(new Locale[0]));
        }
    }

    public FindOptions include(String ... fields) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        this.includes.addAll(List.of(fields));
        this.validateProjections();
        return this.options;
    }

    public FindOptions knownFields() {
        this.knownFields = true;
        return this.options;
    }

    @Nullable
    public Document map(Mapper mapper, Class<?> type) {
        if (this.includes != null || this.excludes != null) {
            return this.project(mapper, type);
        }
        if (this.arrayField != null && this.slice != null) {
            return this.slice(mapper, type);
        }
        if (this.meta != null) {
            return this.meta(mapper, type);
        }
        if (Boolean.TRUE.equals(this.knownFields)) {
            return this.knownFields(mapper, type);
        }
        return null;
    }

    private void iterate(Mapper mapper, Document projection, Class<?> clazz, @Nullable List<String> fields, int include) {
        if (fields != null) {
            for (String field : fields) {
                projection.put(new PathTarget(mapper, mapper.getEntityModel(clazz), field).translatedPath(), (Object)include);
            }
        }
    }

    private Document knownFields(Mapper mapper, Class<?> clazz) {
        Document projection = new Document();
        mapper.getEntityModel(clazz).getProperties().stream().map(mf -> new PathTarget(mapper, mapper.getEntityModel(clazz), mf.getMappedName()).translatedPath()).forEach(name -> projection.put(name, (Object)1));
        return projection;
    }

    private Document meta(Mapper mapper, Class<?> clazz) {
        String fieldName = new PathTarget(mapper, clazz, this.meta.getField(), false).translatedPath();
        return new Document(fieldName, this.meta.toDatabase().get((Object)this.meta.getField()));
    }

    private Document project(Mapper mapper, Class<?> clazz) {
        Document projection = new Document();
        this.iterate(mapper, projection, clazz, this.includes, 1);
        this.iterate(mapper, projection, clazz, this.excludes, 0);
        EntityModel model = mapper.getEntityModel(clazz);
        Entity entityAnnotation = model.getEntityAnnotation();
        if (this.isIncluding() && entityAnnotation != null && entityAnnotation.useDiscriminator()) {
            projection.put(mapper.getConfig().discriminatorKey(), (Object)1);
        }
        return projection;
    }

    private Document slice(Mapper mapper, Class<?> clazz) {
        String fieldName = new PathTarget(mapper, mapper.getEntityModel(clazz), this.arrayField).translatedPath();
        return new Document(fieldName, (Object)this.slice.toDatabase());
    }

    boolean isIncluding() {
        return this.includes != null && !this.includes.isEmpty();
    }

    public FindOptions project(String field, ArraySlice slice) {
        this.arrayField = field;
        this.slice = slice;
        this.validateProjections();
        return this.options;
    }

    public FindOptions project(Meta meta) {
        this.meta = meta;
        this.validateProjections();
        return this.options;
    }

    public String toString() {
        return new StringJoiner(", ", Projection.class.getSimpleName() + "[", "]").add("includes=" + this.includes).add("excludes=" + this.excludes).add("arrayField='" + this.arrayField + "'").add("slice=" + this.slice).add("meta=" + this.meta).add("knownFields=" + this.knownFields).toString();
    }
}

