/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.client.MongoCollection;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.DatastoreImpl;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.LegacyQuery;
import dev.morphia.query.MorphiaQuery;
import dev.morphia.query.Operations;
import dev.morphia.query.Query;
import dev.morphia.query.internal.DatastoreAware;
import dev.morphia.query.updates.UpdateOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;

@MorphiaInternal
public abstract class UpdateBase<T> {
    private final Query<T> query;
    private final MongoCollection<T> collection;
    private final Mapper mapper;
    private final Class<T> type;
    private final List<UpdateOperator> updates = new ArrayList<UpdateOperator>();
    private final DatastoreImpl datastore;

    UpdateBase(DatastoreImpl datastore, @Nullable MongoCollection<T> collection, @Nullable Query<T> query, Class<T> type, List<UpdateOperator> updates) {
        this.datastore = datastore;
        this.mapper = datastore.getMapper();
        this.type = type;
        this.updates.addAll(updates);
        this.query = query;
        this.collection = collection;
    }

    @NonNull
    static <T> List<T> coalesce(T first, T[] updates) {
        ArrayList<T> operators = new ArrayList<T>();
        operators.add(first);
        operators.addAll(Arrays.asList(updates));
        return operators;
    }

    @MorphiaInternal
    public void add(UpdateOperator operator) {
        this.updates.add(operator);
    }

    public Document toDocument() {
        Operations operations = new Operations(this.datastore, this.mapper.getEntityModel(this.type));
        for (UpdateOperator update : this.updates) {
            PathTarget pathTarget = new PathTarget(this.mapper, this.mapper.getEntityModel(this.type), update.field(), this.validate());
            if (update instanceof DatastoreAware) {
                ((DatastoreAware)((Object)update)).setDatastore(this.datastore);
            }
            operations.add(update.operator(), update.toTarget(pathTarget));
        }
        return operations.toDocument();
    }

    private boolean validate() {
        return this.query instanceof MorphiaQuery ? ((MorphiaQuery)this.query).isValidate() : ((LegacyQuery)this.query).isValidate();
    }

    public String toString() {
        return this.toDocument().toString();
    }

    protected MongoCollection<T> getCollection() {
        return this.collection;
    }

    protected DatastoreImpl getDatastore() {
        return this.datastore;
    }

    protected Query<T> getQuery() {
        return this.query;
    }

    @MorphiaInternal
    protected List<UpdateOperator> getUpdates() {
        return this.updates;
    }
}

