/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.filters;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.aggregation.codecs.ExpressionHelper;
import dev.morphia.annotations.internal.MorphiaInternal;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.PropertyHandler;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.query.OperationTarget;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;

public class Filter {
    private final String name;
    private String field;
    @Nullable
    private Object value;
    private boolean not;
    private boolean validate;
    private Class<?> entityClass;
    private PathTarget pathTarget;
    private boolean mapped;

    protected Filter(String name) {
        this.name = name;
    }

    protected Filter(String name, @Nullable String field, @Nullable Object value) {
        this.name = name;
        this.field = field != null ? field : "";
        this.value = value;
    }

    @MorphiaInternal
    public boolean isNot() {
        return this.not;
    }

    @MorphiaInternal
    public void encode(Datastore datastore, BsonWriter writer, EncoderContext context) {
        ExpressionHelper.document(writer, this.path(datastore.getMapper()), () -> {
            if (this.not) {
                ExpressionHelper.document(writer, "$not", () -> this.writeNamedValue(this.name, this.getValue(datastore), datastore, writer, context));
            } else {
                this.writeNamedValue(this.name, this.getValue(datastore), datastore, writer, context);
            }
        });
    }

    @MorphiaInternal
    public Filter entityType(Class<?> type) {
        this.entityClass = type;
        return this;
    }

    @Nullable
    @MorphiaInternal
    public String getField() {
        return this.field;
    }

    public Filter not() {
        this.not = true;
        return this;
    }

    @Nullable
    @MorphiaInternal
    public String getName() {
        return this.name;
    }

    @Nullable
    @MorphiaInternal
    public Object getValue() {
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    @MorphiaInternal
    public Filter isValidating(boolean validate) {
        this.validate = validate;
        this.pathTarget = null;
        this.mapped = false;
        return this;
    }

    @Nullable
    protected Object getValue(Datastore datastore) {
        if (!this.mapped) {
            PathTarget target = this.pathTarget(datastore.getMapper());
            OperationTarget operationTarget = new OperationTarget(this.pathTarget, this.value);
            this.value = operationTarget.getValue();
            PropertyModel property = target.target();
            if (property != null && property.specializeCodec(datastore) instanceof PropertyHandler) {
                this.value = ((Document)operationTarget.encode(datastore)).get((Object)this.field);
            }
            this.mapped = true;
        }
        return this.value;
    }

    public String toString() {
        return String.format("%s %s %s", this.field, this.name, this.value);
    }

    protected String path(Mapper mapper) {
        return this.pathTarget(mapper).translatedPath();
    }

    private PathTarget pathTarget(Mapper mapper) {
        if (this.pathTarget == null) {
            this.pathTarget = new PathTarget(mapper, this.entityClass, this.field, this.validate);
        }
        return this.pathTarget;
    }

    protected void writeNamedValue(@Nullable String name, @Nullable Object value, Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeName(name);
        if (value != null) {
            Codec codec = datastore.getCodecRegistry().get(value.getClass());
            encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
        } else {
            writer.writeNull();
        }
    }

    protected void writeUnnamedValue(@Nullable Object value, Datastore datastore, BsonWriter writer, EncoderContext encoderContext) {
        if (value != null) {
            Codec codec = datastore.getCodecRegistry().get(value.getClass());
            encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
        } else {
            writer.writeNull();
        }
    }
}

